package net.mail;

import ip.gui.frames.ClosableFrame;

import java.applet.Applet;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;


public class SendMailApplet extends Applet {

  //
  // The e-mail addBk.address all messages are to be sent to; specified in HTML
  //
  private String recipientEmailAddress = null;

  private String emailServerHostName = null;
  private boolean standalone = false;
  private int smtpPort = 25;
  private Socket socket;
  private PrintWriter pw;
  private InetAddress remoteInternetAddress;
  private InetAddress localInternetAddress;

  private EmailClientGui form;


  /**
   * Initialize the applet.
   */
  public void init() {

    setBackground(Color.white);
    form = new EmailClientGui(this);
    add(form);
    setSize(600, 450);
    if (emailServerHostName == null)
      emailServerHostName = getCodeBase().getHost();
    if (recipientEmailAddress == null)
      recipientEmailAddress = getParameter("RECIPIENT");
  }


  /**
   * Show status to the user.
   */
  public void showStatus(String s) {

    System.out.println(s);
    if (standalone) return;
    super.showStatus(s);
  }


  private BufferedReader br;

  /**
   * Send an e-mail message.
   */
  public void send() throws IOException, Exception {

    // Open connection to SMTP server
    socket = new Socket(emailServerHostName, smtpPort);

    // Send the form contents as a message
    try {
      remoteInternetAddress =
          socket.getInetAddress();
      localInternetAddress =
          remoteInternetAddress.getLocalHost();

      //
      //  Conversion of the PrintStream due to deprication.
      //     ps = new PrintStream(socket.getOutputStream());
      //
      //  Print values and objects to a Writer.
      //
      pw = new PrintWriter(socket.getOutputStream());

      //
      //  Conversion of the DataInputStream due to deprication.
      //    dis  = new DataInputStream(socket.getInputStream());
      //
      //  Use BufferedReader instead of DataInputStream.
      //
      br = new BufferedReader(new InputStreamReader(socket.getInputStream()));

      // Send message
      sendline("HELO " + localInternetAddress.toString());
      sendline("MAIL FROM:" + form.email());
      sendline("RCPT TO:" + recipientEmailAddress);
      sendline("DATA");
      sendline(form.message());
      sendline(".");
    } catch (Exception ex) {
      socket.close();
      throw ex;
    }

    // Close connection
    socket.close();
  }


  /**
   * Send a line of data to the server, and retrieve the handshake
   */
  void sendline(String data) throws IOException {

    System.out.println("sendline out:" + data);
    pw.println(data);
    pw.flush();
    //
    //  Conversion of the DataInputStream due to deprication.
    //
    // String s = dis.readLine();
    //
    String s = br.readLine();
    System.out.println("sendline in:" + s);
  }


  /**
   * Main routine, for standalone program execution
   */
  public static void main(String args[]) {

    SendMailApplet ap = new SendMailApplet();
    // The server host will be the place running POP
    // webmaster e-mail will be recipient
    ap.emailServerHostName = "192.168.1.96";
    ap.recipientEmailAddress = "lyon@docjava.com";
    ap.standalone = true;

    ClosableFrame fr = new ClosableFrame("SendMail");
    ap.init();
    fr.add("Center", ap);
    fr.setSize(600, 450);

    fr.show();
    ap.start();
  }

  public String getWebmasterEmail() {
    return recipientEmailAddress;
  }

  public void setWebmasterEmail(String webmasterEmail) {
    this.recipientEmailAddress = webmasterEmail;
  }

  public String getServerHostName() {
    return emailServerHostName;
  }

  public void setServerHostName(String serverHostName) {
    this.emailServerHostName = serverHostName;
  }

  public boolean isStandalone() {
    return standalone;
  }

  public void setStandalone(boolean standalone) {
    this.standalone = standalone;
  }

  public int getSmtpPort() {
    return smtpPort;
  }

  public void setSmtpPort(int smtpPort) {
    this.smtpPort = smtpPort;
  }

  public Socket getSocket() {
    return socket;
  }

  public void setSocket(Socket socket) {
    this.socket = socket;
  }

  public PrintWriter getPs() {
    return pw;
  }

  public void setPs(PrintWriter ps) {
    this.pw = ps;
  }

  public InetAddress getRina() {
    return remoteInternetAddress;
  }

  public void setRina(InetAddress rina) {
    this.remoteInternetAddress = rina;
  }

  public InetAddress getLina() {
    return localInternetAddress;
  }

  public void setLina(InetAddress lina) {
    this.localInternetAddress = lina;
  }

  public EmailClientGui getForm() {
    return form;
  }

  public void setForm(EmailClientGui form) {
    this.form = form;
  }

  public BufferedReader getBuf_reader() {
    return br;
  }

  public void setBuf_reader(BufferedReader buf_reader) {
    this.br = buf_reader;
  }
}


/**
 * A form for obtaining user input. Customize this for your application, just
 * as you would customize an HTML form for a Web-based e-mail application.
 */
class EmailClientGui extends Panel implements ActionListener {

  SendMailApplet applet;

  // The form's elements...
  Label nameLabel;
  TextField nameField;
  Label emailLabel;
  TextField emailField;
  Label orgLabel;
  TextField orgField;
  Label msgBodyLabel;
  TextArea msgBodyArea;
  Button sendButton;


  /**
   * The constructor
   */
  public EmailClientGui(SendMailApplet ap) {

    applet = ap;
    setBackground(Color.white);
    setLayout(new GridLayout(2, 1));

    // Create a panel to put the text fields and button on
    Panel p = new Panel();
    p.setLayout(new GridLayout(8, 1));

    // Instantiate all the elements, and add them to their containers...
    p.add(sendButton = new Button("Send"));
    sendButton.addActionListener(this);
    p.add(nameLabel = new Label("Your Name:"));
    p.add(nameField = new TextField(60));
    p.add(emailLabel = new Label("Your e-mail addBk.address:"));
    p.add(emailField = new TextField(60));
    p.add(orgLabel = new Label("Your orgainization:"));
    p.add(orgField = new TextField(60));
    p.add(msgBodyLabel = new Label("Your Message:"));
    add(p);
    add(msgBodyArea = new TextArea(3, 60));

    // Set the size of the form
    setSize(550, 500);
  }


  /**
   * Return the value in the e-mail addBk.address field in the form
   */
  public String email() {
    return emailField.getText();
  }


  //
  //  Updated to the new Event model.
  //
  public void actionPerformed(ActionEvent e) {

    if (e.getSource() == sendButton) {

      //
      // User clicked the Send button; send the message
      //
      try {
        applet.send();
      } catch (Exception ex) {
        applet.showStatus("Error; message send failed:\n  " + ex.toString());

        return;
      }
      applet.showStatus("Message sent");

      return;
    }
  }


  /**
   * Return the contents of the body of the form, including any "hidden" fields.
   */
  public String message() {

    String m = "";

    m += nameLabel.getText();
    m += nameField.getText();
    m += "\n";

    m += orgLabel.getText();
    m += orgField.getText();
    m += "\n";

    m += "Web Origin:";
    if (!applet.isStandalone()) m += applet.getDocumentBase();
    m += "\n";

    m += "Date Sent:";
    m += (new Date()).toString();
    m += "\n";

    m += msgBodyLabel.getText();
    m += msgBodyArea.getText();
    m += "\n";

    return m;
  }
}   // end Form class
