package net.compute;


import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
/**
 * 1. Use the ComputeClient to create a Reloader
 * that gives you bytes codes.
 * 2. Get the RemoteClassLoader and send it to the
 *   compute server.
 * 3. The compute server define and computes the class using
 *   the remote class loader.
 * 4. It then returns the answer to the compute client.
 */

public class ComputeClient implements Runnable {
    private ComputableObject computeIt = new BigComputation();
    private String computeServer = "172.16.11.107";
    private int computeServerPort = 8088;

    public void setComputableObject(ComputableObject co) {
        computeIt = co;
    }

    public static void main(String args[]) {
        ComputeClient cc = new ComputeClient();
        //cc.setComputableObject( new ANewComputableObject());
        cc.run();
    }

    public void run() {
        try {
            Socket s
                    = new Socket(computeServer, computeServerPort);
            ObjectInputStream
                    ois =
                    new ObjectInputStream(
                            s.getInputStream());
            ObjectOutputStream
                    oos =
                    new ObjectOutputStream(
                            s.getOutputStream());
            oos.writeObject(computeIt);
            // block the thread of execution
            // until the computation is finished by
            // the compute server. E.g.
            // a = f(b);
            Object o = ois.readObject();
            System.out.println(o);
            ois.close();
            oos.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ANewComputableObject
            implements ComputableObject {
        public Serializable compute() {
            return "this is really different";
        }
    }
}