package net.compute;

import classUtils.dumper.ClassFile;
import classUtils.dumper.Dump;

import java.io.*;

/**
Send the ByteCodeContainer to a remote
 JVM. It uses the RCL to define a new class and
 compute an answer. Computation servers need these
 things to be sent by the computation clients.
 */

public class ByteCodeContainer
        extends ClassLoader
        implements Serializable {
    String className;
    byte byteCodes[];

    public static ByteCodeContainer getLoader(ComputableObject o){
        return new ByteCodeContainer(o.getClass());
    }

    public ByteCodeContainer(Class c){
        className = c.getName();
        ReLoader rl = new ReLoader("C:\\lyon\\j4p\\classes");
        byteCodes = rl.getByteCodes(className);

    }


    public ByteCodeContainer(String cn, byte b[]){
        byteCodes = b;
        className = cn;
    }


    public void loadIt() {
        loadClass(className, true);
    }
    // for homework
    // write a program
    // in Java. That can list
    // All of the methods that contain
    // a method that is of  the signature
    // public static void main(String args[])
    // These methods can be in many classes
    // and all must reside in a package that is given.
    // For example:
    // Method [] getMainMethods(Package p);
    // Method m[] = getMainMethods(networkPackage);
    // returns a list of methods that are in the networkPackage
    public Serializable compute()
            throws InstantiationException, IllegalAccessException {
        Class c = defineClass(
                        className, byteCodes, 0, byteCodes.length);
        Object o = c.newInstance();
        if (! (o instanceof ComputableObject)){
            System.out.println("this is computable in remoteclass loader");
            return null;
        }
        return ((ComputableObject)o).compute();
    }

    public void reload() {
        // force the class to be reloaded,
        // in case it has changed.
        try {
            Class c = defineClass(
                    className, byteCodes, 0, byteCodes.length);
            System.out.println("resolving:" + className);
            resolveClass(c);
        } catch (Exception e) {

        }
    }

    protected synchronized Class loadClass(String s, boolean b) {
        Class cl = findLoadedClass(s);
        try {
            if (cl == null)  // not in cache!
                return findSystemClass(s);
        } catch (ClassNotFoundException e) {
        }
        System.out.println("defining:" + s);
        Class c = defineClass(
                className, byteCodes, 0, byteCodes.length);
        System.out.println("resolving:" + className);
        if (c != null && b) resolveClass(c);
        return c;
    }
    public static ByteCodeContainer getByteCodeContainer(){
        return getByteCodeContainer(
                futils.Futil.getFileInputStream("Select a class file"));

    }

    public static ByteCodeContainer getByteCodeContainer(FileInputStream fis) {

        Dump dc = new Dump();
        ClassFile cf = dc.printInputStream(fis);
        //System.out.println("class Dumper say I have:"+cf.getClassName());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            cf.write(baos);
            baos.close();
            byte b[] = baos.toByteArray();
            //System.out.println("bytecode found:"+b.length);
            ByteCodeContainer bcc = new ByteCodeContainer(cf.getClassName(),b);
            //System.out.println("got class!"+bcc.getClass());
            return bcc;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}