package net.compute;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;


public class AutoServer implements Runnable {
    public final static int PORT = 8000;

    public static void main(String args[]) {
        Thread serverThread = new Thread(new AutoServer());
        serverThread.start();
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
        }
    }

    public void run() {
        try {
            ServerSocket ss =
                    new ServerSocket(PORT);
            while (true) {
                System.out.println("autoServerThread waiting");
                Socket socket = ss.accept();
                (new AutoServerThread1(socket)).start();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}

class AutoServerThread1 extends
        Thread {
    private ObjectInputStream ois;
    private ObjectOutputStream oos;

    AutoServerThread1(Socket s)
            throws IOException {
        oos =
                new ObjectOutputStream(
                        s.getOutputStream());

        ois =
                new ObjectInputStream(
                        s.getInputStream());
    }

    public void run() {
        try {
            Object o1 = ois.readObject();
            ByteCodeContainer bcc = null;
            if (! (o1 instanceof ByteCodeContainer)) {
                System.out.println("bad objects!");
                return;
            }
            bcc = ((ByteCodeContainer) o1);
            Serializable ans = bcc.compute();
            oos.writeObject(ans);
            oos.close();
            ois.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public java.io.ObjectInputStream getOis() {
        return ois;
    }

    public void setOis(java.io.ObjectInputStream ois) {
        this.ois = ois;
    }

    public java.io.ObjectOutputStream getOos() {
        return oos;
    }

    public void setOos(java.io.ObjectOutputStream oos) {
        this.oos = oos;
    }
}
