package math;

import j2d.ShortImageBean;

import java.awt.*;

/**
 * GPL code by DocJava, Inc.
 * User: lyon
 * Date: Mar 5, 2003
 * Time: 4:33:57 PM
 * 
 */
public class RgbStats  {
    private Stats redStats =  new Stats();
    private Stats greenStats =  new Stats();
    private Stats blueStats =  new Stats();

    public RgbStats(Image img){
        ShortImageBean sib = new ShortImageBean(img);
        getRedStats().initStats(sib.getR());
        getGreenStats().initStats(sib.getG());
        getBlueStats().initStats(sib.getB());
    }
    public double [] getAverageCmf() {
        double CMFr[] = redStats.getCMF();
        double CMFg[] = greenStats.getCMF();
        double CMFb[] = blueStats.getCMF();
        return Mat2.getAverage(CMFr, CMFg, CMFb);
    }

    public Stats getRedStats() {
        return redStats;
    }

    public Stats getGreenStats() {
        return greenStats;
    }

    public Stats getBlueStats() {
        return blueStats;
    }
}
