package math;

import java.math.BigInteger;

/**
 * Created by
 * User: lyon
 * Date: Aug 23, 2003
 * Time: 10:07:55 PM
 *
 */
public class Prime {


    /**
     * Uses a trivail algorithm to determing the first N prime numbers.
     * The algorithm is not computationally efficient, however it requires
     * nearly zero storage.  And besides, we're trying to stress the processor.
     *
     */
    /** Represents the number of prime numbers to calculate. */
    private int n = 0;

    private BigInteger TWO = new BigInteger("2");

    /** */
    private BigInteger primes[] = null;

    /** */
    private int primeCount = 0;

    /** */
    public Prime(int n) {
        this.n = n;

        primes = new BigInteger[n];
        primes[0] = new BigInteger("2");
        primes[1] = new BigInteger("3");

        primeCount = 1;
    }

    /** */
    public void calculate() {
        System.out.println("Calculating " + n + " primes");
        int primeCount = 1;

        BigInteger test = new BigInteger("5");
        while (primeCount < n - 1) {
            if (isPrime(test)) {
                primeCount++;
                primes[primeCount] = test;
            } else {
                //if (test.isProbablePrime(2))
                if (false)
                    System.out.println(test + " is probable, but not prime");
            }
            test = test.add(TWO);
        }
        System.out.println("the " + n + "th prime is " + primes[n - 1]);
    }

    private final boolean isPrime(BigInteger bi) {
        BigInteger half = bi.divide(TWO);
        for (BigInteger i = TWO;
             i.compareTo(half) == -1;
             i = i.add(BigInteger.ONE)) {
            BigInteger q[] = bi.divideAndRemainder(i);

            // If the remainder of the division is zero, the number is not prime.
            if (q[1].equals(BigInteger.ZERO))
                return false;
        }
        return true;
    }



    public static void main(String args[]) {
        int count = 10000;
        Prime prime = new Prime(count);
        long start = System.currentTimeMillis();
        prime.calculate();
        long end = System.currentTimeMillis();
        System.out.println("The " + count + "th prime is " + prime.primes[count - 1]);
        System.out.println("Time to calculate: " + (end - start));
    }
}

