package math;



public abstract class Mat1 {

    public static void main(String args[]) {
        float f[] = new float[3];
        for (int i = 0; i < f.length; i++)
            f[i] = 1;
        Mat1.normalize(f);
        //Mat.printKernel(f,"mean3");
    }

    public static void print(double a[]) {
        for (int i = 0; i < a.length; i++) {

            System.out.print(a[i] + " ");
            System.out.println();
        }
    }

    public static void printStats(String title, float a[]) {
        System.out.println(title);
        printStats(a);
    }

    public static void printStats(float a[]) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        float aBar = 0;


        double N = a.length;
        for (int x = 0; x < a.length; x++) {

            aBar += a[x];

            min = Math.min(a[x], min);
            max = Math.max(a[x], max);
        }


        aBar /= N;

        System.out.println(
                " aBar=" + aBar +
                " a min=" + min +
                " a max=" + max +
                " a.length=" + a.length +
                " a[0].length=" + a.length);

    }

    public static void print(float a[]) {
        for (int i = 0; i < a.length; i++) {
            System.out.print(a[i] + " ");
            System.out.println();
        }
    }

    public static double sum(double a[]) {
        double s = 0.0;
        for (int i = 0; i < a.length; i++)
            s += a[i];
        return s;
    }

    public static double sum(float a[]) {
        double s = 0.0;
        for (int i = 0; i < a.length; i++)
            s += a[i];
        return s;
    }

    public static double sum(short a[]) {
        double s = 0.0;
        if (a == null) return 0;
        for (int i = 0; i < a.length; i++)
            s += a[i];
        return s;
    }

    public static short clip(short i) {
        if (i < 0)
            return 0;

        if (i > 255)
            return 255;

        return i;
    }

    public static short[][] clip(short i[][]) {
        short i2[][] = new short[i.length][i[0].length];
        for (int x = 0; x < i2.length; x++)
            for (int y = 0; y < i2[0].length; y++)
                i2[x][y] = clip(i[x][y]);
        return i2;
    }

    public static void normalize(double a[]) {
        scale(a, 1.0 / sum(a));
    }

    public static float[] normalize(short a[]) {
        return scale(a, (float) (1.0f / sum(a)));
    }

    public static void normalize(float a[]) {
        scale(a, 1.0 / sum(a));
    }

    public static double average(double a[]) {
        int n = a.length * a.length;
        return sum(a) / n;
    }

    public static double average(float a[]) {
        int n = a.length * a.length;
        return sum(a) / n;
    }

    public static double average(short a[]) {
        int n = a.length * a.length;
        return sum(a) / n;
    }

    public static void threshold(short a[], short thresh) {
        for (int i = 0; i < a.length; i++)
            if (a[i] < thresh)
                a[i] = 0;
            else
                a[i] = 255;
    }

    public static void threshold( short a[]) {
        threshold(a, (short) average(a));
    }


    public static float[] scale(short a[], float k) {
        if (a == null) return null;
        float f[] = new float[a.length];
        for (int i = 0; i < a.length; i++) {
            f[i] = k * a[i];
        }
        return f;

    }

    public static void scale(double a[], double k) {
        System.out.println("scale(double a[], double k)");
        for ( int i = 0; i < a.length; i++) {

            a[i] *= k;
        }

    }

    public static void scale(float a[], float k) {
        if (a == null) return;
        for (int i = 0; i < a.length; i++) {
            a[i] = a[i] * k;
        }
    }

    public static void scale(float a[], double k) {
//System.out.println("scale(float a[][], double k)");
//	System.out.println("k="+k);
        scale(a, (float) k);
    }

    public static float[] shortToFloat(short a[]) {
        int w = a.length;

        float c[] = new float[w];
        for (int i = 0; i < w; i++)
                c[i] = a[i];
        return c;
    }

    public static short[] copyArray(short a[]) {
        int w = a.length;

        short c[] = new short[w];
        for (int i = 0; i < w; i++)
            c[i] = a[i];
        return c;
    }

    public static double variance(int a[]) {
        double xBar = mean(a);
        double sum = 0;
        double dx = 0;
        for (int i = 0; i < a.length; i++) {
            dx = a[i] - xBar;
            sum += dx * dx;
        }
        return sum / a.length;
    }

    public static double mean(int a[]) {
        double sum = 0;
        for (int i = 0; i < a.length; i++)
            sum += a[i];
        return sum / a.length;
    }

    public static double coefficientOfVariation(int a[]) {
        double aBar = mean(a);
        double aBar2 = aBar * aBar;
        return Math.sqrt(variance(a) / aBar2);
    }

    public static void testVariance() {
        int a[] = {1, 2, 3, 5, 4, 3, 2, 5, 6, 7};
        System.out.println("The variance =" + variance(a));
    }

    public static void testCoefficientOfVariation() {
        int a[] = {0, 85, 87, 90, 100};
        System.out.println(
                "coefficientOfVariation({0,85,87,90,100}) ="
                + coefficientOfVariation(a));
        int b[] = {95, 85, 87, 90, 100};
        System.out.println(
                "The coefficientOfVariation({95,85,87,90,100}) ="
                + coefficientOfVariation(b));
    }

    public static boolean outlierHere(int a[]) {
        return (coefficientOfVariation(a) > .1);
    }

    public static void testOutlier() {
        int a[] = {0, 85, 87, 90, 100};
        int b[] = {95, 85, 87, 90, 100};
        System.out.println(
                "dog ate my homework ={0,85,87,90,100}"
                + outlierHere(a));
        System.out.println(
                "dog ate my homework ={95,85,87,90,100}"
                + outlierHere(b));
    }

    public static void quickSort(int a[], int lo0, int hi0) {
// Based on the QuickSort method by
// James Gosling from Sun's SortDemo applet

        int lo = lo0;
        int hi = hi0;
        int mid, t;

        if (hi0 > lo0) {
            mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while ((lo < hi0) && (a[lo] < mid))
                    ++lo;
                while ((hi > lo0) && (a[hi] > mid))
                    --hi;
                if (lo <= hi) {
                    t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                    ++lo;
                    --hi;
                }
            }
            if (lo0 < hi)
                quickSort(a, lo0, hi);
            if (lo < hi0)
                quickSort(a, lo, hi0);

        }
    }

    public static void swap(int x[], int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void quickSort(int a[]) {
        quickSort(a, 0, a.length - 1);
    }

    public static double mean(short a[][]) {
        double sum = 0;
        for (int x = 0; x < a.length; x++)
            for (int y = 0; y < a[0].length; y++) {
                sum += a[x][y];
            }
        return sum / (a.length * a[0].length);
    }

    public static double variance(short a[][]) {
        double xBar = mean(a);
        double sum = 0;
        double dx = 0;
        for (int x = 0; x < a.length; x++)
            for (int y = 0; y < a[0].length; y++) {
                dx = a[x][y] - xBar;
                sum += dx * dx;
            }
        return sum / (a.length * a[0].length);
    }

    public static double[] getAverage(
            double a[], double b[], double c[]) {
        double avg[] = new double[a.length];

        for (int i = 0; i < a.length; i++) {
            avg[i] = (a[i] + b[i] + c[i]) / 3.0;
        }
        return avg;
    }

    public static short[][] copy(short r[][]) {
        short c[][] = new short[r.length][r[0].length];
        int w = r.length;
        int h = r[0].length;
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++)
                c[x][y] = r[x][y];
        return c;
    }

    public static short getMin(short a[]) {
        short min = 255;
        for (int i = 0; i < a.length; i++)
            if (a[i] < min)
                min = a[i];
        return min;
    }

    public static short getMax(short a[]) {
        short max = -255;
        for (int i = 0; i < a.length; i++)
            if (a[i] > max)
                max = a[i];
        return max;
    }


    public static void testQuickSort() {
        int a[] = {1, 2, 3, 5, 4, 3, 2, 5, 6, 7};
        quickSort(a);
        for (int i = 0; i < a.length; i++)
            System.out.println(a[i]);
    }

    public static int numberOfNonZeros(short k[][]) {
        int umax = k.length;
        int vmax = k[0].length;
        int sum = 0;

        for (int x = 0; x < umax; x++)
            for (int y = 0; y < vmax; y++)
                if (k[x][y] != 0) sum++;
        return sum;
    }

    public static void printMedian(short k[][], String name) {
//printMaple(k);
        System.out.println(
                "\npublic void " + name + "(){\n"
                + "\tfloat k[][] = {");
        int w = k.length;
        int h = k[0].length;

        for (int y = 0; y < h; y++) {
            System.out.print("\t{");
            for (int x = 0; x < w - 1; x++)
                System.out.print(k[x][y] + ", ");
            String s = k[w - 1][y] + "}";
            if (y < h - 1)
                s = s + ",";
            else
                s = s + "};";
            System.out.println(s);
        }

        String s = "\n\tmedian(k);\n}";
        System.out.println(s);

    }


}
