package j3d.cr325;

import j3d.Utils;

import javax.media.j3d.*;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Mar 10, 2004
 * Time: 4:36:29 PM
 */
public class Target {
    /**
     * Switch that is used to swap the target models
     */
    private static Switch targetSwitch = getTargetSwitch();

    public static Switch getTargetSwitch() {
        if (targetSwitch != null) return targetSwitch;
        Switch s = new Switch(0);
        s.setCapability(Switch.ALLOW_SWITCH_WRITE);
        return s;
    }

    public static BranchGroup getTargetGroup() {
          BranchGroup theTarget = new BranchGroup();
          Switch s = getTargetSwitch();
          TransformGroup targetRotationTransformGroup = new TransformGroup();
          Transform3D targetRotationTransform = new Transform3D();
          Matrix3d targetRotationMatrix = new Matrix3d();
          targetRotationMatrix.rotY(Math.PI / 2);
          targetRotationTransform.set(
                  targetRotationMatrix,
                  new Vector3d(0.0, 0.0, -30.0), 1.0);
          targetRotationTransformGroup.setTransform(targetRotationTransform);
          targetRotationTransformGroup.addChild(s);
          s.addChild(
                  Utils.getTextureSphere(1,0,0.5,"gifs\\animation1.gif")
          );
          s.addChild(
                  Utils.getTextureSphere(1,0,0.5,"color\\airplane.JPEG")
          );

          TransformGroup targetMotionTransformGroup = new TransformGroup();
          targetMotionTransformGroup.setCapability(
                  TransformGroup.ALLOW_TRANSFORM_READ);
          targetMotionTransformGroup.setCapability(
                  TransformGroup.ALLOW_TRANSFORM_WRITE);
          targetMotionTransformGroup.addChild(
                  targetRotationTransformGroup);
          Alpha a = new Alpha(-1, 0, 0, 3000, 0, 0);

          Utils.addMotion( a, targetMotionTransformGroup, theTarget);
          return theTarget;
      }
}
