package j3d.cr325;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import java.applet.Applet;
import java.awt.*;

import j3d.Utils;


public class Solid5 extends Applet {
    Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f blue = new Color3f(0.0f, 0.0f, 0.8f);

    private BranchGroup createSceneGraph() {
        // Create the root of the branch graph
        BranchGroup objRoot = new BranchGroup();
        addBackgroundAndLights(
                new BoundingSphere(
                        new Point3d(0.0, 0.0, 0.0), 100.0),
                objRoot);
        addObjects(objRoot);

        return objRoot;
    }

    private void addBackgroundAndLights(BoundingSphere bounds, BranchGroup objRoot) {
        addBackground(bounds, objRoot);
        addLights(bounds, objRoot);
    }

    private void addBackground(BoundingSphere bounds, BranchGroup objRoot) {
        Background bg = //Utils.getMandlebrotBackground(640, 480);
                Utils.getImageBackground("gifs\\animation2.gif");
        bg.setApplicationBounds(bounds);
        objRoot.addChild(bg);
    }

    private void addObjects(BranchGroup objRoot) {
        Appearance ap1 = new Appearance();
        Appearance ap2 = new Appearance();
        Appearance ap3 = new Appearance();

        ap1.setMaterial(new Material(blue, black, blue,
                white, 80.0f));
        objRoot.addChild(spinningObject(ap1, 0.2, -.6, -.7, 0.0));
        blue = new Color3f(0.8f, 0.0f, 0.0f);
        ap2.setMaterial(new Material(blue, black, blue,
                white, 80.0f));
        objRoot.addChild(spinningObject(ap2, 0.2, 0.0, -.5, 0.38));
        blue = new Color3f(0.8f, 0.8f, 0.0f);
        Material m1 = new Material(blue, black, blue,
                white, 80.0f);
        m1.setShininess(128f);
        ap3.setMaterial(m1);
        objRoot.addChild(spinningObject(ap3, 0.2, .5, -.7, 0.0));

        // Let Java 3D perform optimizations on this scene graph.
        objRoot.compile();
    }

    private void addLights(BoundingSphere bounds, BranchGroup objRoot) {
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Vector3f lDir1 = new Vector3f(-1.0f, -0.3f, -1.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);

        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds(bounds);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        lgt1.setInfluencingBounds(bounds);
        objRoot.addChild(aLgt);
        objRoot.addChild(lgt1);
    }

    private Group spinningObject(Appearance app, double scale,
                                 double xpos, double ypos, double zpos) {
        TransformGroup objTrans = getTransformgroup(scale, xpos, ypos, zpos);
        TransformGroup spinTg = addTGAndEnableTransformWriteSoItCanBeModified();
        addCylinder(app, spinTg);

        Alpha rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE,
                0, 0, 5000, 0, 0, 0, 0, 0);

        RotationInterpolator rotator =
                new RotationInterpolator(rotationAlpha, spinTg);

        BoundingSphere bounds =
                new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);

        rotator.setSchedulingBounds(bounds);
        addBehaviorAndTransformGroup(objTrans, rotator, spinTg);
        return objTrans;
    }

    private TransformGroup addTGAndEnableTransformWriteSoItCanBeModified() {
        TransformGroup spinTg = new TransformGroup();
        spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        return spinTg;
    }

    private void addBehaviorAndTransformGroup(TransformGroup objTrans,
                                              RotationInterpolator rotator,
                                              TransformGroup spinTg) {
        objTrans.addChild(rotator);
        objTrans.addChild(spinTg);
    }

    private void addCylinder(Appearance app, TransformGroup spinTg) {
        Primitive obj = new Cylinder(1.0f, 0.2f);
        obj.setAppearance(app);
        spinTg.addChild(obj);
    }

    private TransformGroup getTransformgroup(double scale, double xpos, double ypos, double zpos) {
        Transform3D t = new Transform3D();
        t.set(scale, new Vector3d(xpos, ypos, zpos));
        TransformGroup objTrans = new TransformGroup(t);
        return objTrans;
    }

    public Solid5() {
        setLayout(new BorderLayout());
        Canvas3D c = Utils.getCanvas3D(this);
        add("Center", c);

        // Create a simple scene and attach it to the virtual universe
        SimpleUniverse u = new SimpleUniverse(c);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        u.getViewingPlatform().setNominalViewingTransform();
        u.addBranchGraph(createSceneGraph());
    }


    //
    // The following allows Solid5 to be run as an application
    // as well as an applet
    //
    public static void main(String[] args) {
        new MainFrame(new Solid5(), 640, 480);
    }
}
