/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Mar 3, 2004
 * Time: 2:32:59 PM
 * 
 */
package j3d.cr325;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

public class Shapes {
    public static Shape3D getLand() {
        int numberOfLines = 888;
        LineArray la = new LineArray(numberOfLines,
                GeometryArray.COORDINATES
                | GeometryArray.COLOR_3);
        float l = -50.0f;
        for (int c = 0; c < numberOfLines; c += 4) {
            int r = math.MathUtils.rand(1, 10);
            la.setCoordinate(c + 0, new Point3f(-50.0f, 0f, l));
            la.setCoordinate(c + 1, new Point3f(50.0f, 0.0f, l));
            la.setCoordinate(c + 2, new Point3f(l, 0.0f, -50.0f));
            la.setCoordinate(c + 3, new Point3f(l, 0.0f, 50.0f));
            l += 1.0f;
        }

        Color3f c = new Color3f(0.8f, 0.1f, 0.1f);
        for (int i = 0; i < numberOfLines; i++) la.setColor(i, c);

        return new Shape3D(la);
    }

    public static QuadArray getHouse() {
        QuadArray qa = new QuadArray(28, GeometryArray.COORDINATES | GeometryArray.COLOR_3);

        qa.setCoordinate(0, new Point3f(0f, 0f, 0f));
        qa.setCoordinate(1, new Point3f(1f, 0f, 0f));
        qa.setCoordinate(2, new Point3f(1f, 1f, 0f));
        qa.setCoordinate(3, new Point3f(0f, 1f, 0f));

        qa.setCoordinate(4, new Point3f(0.4f, 0f, 0.01f));
        qa.setCoordinate(5, new Point3f(0.6f, 0f, 0.01f));
        qa.setCoordinate(6, new Point3f(0.6f, .5f, 0.01f));
        qa.setCoordinate(7, new Point3f(0.4f, .5f, 0.01f));

        qa.setCoordinate(8, new Point3f(0.2f, .60f, 0.01f));
        qa.setCoordinate(9, new Point3f(0.4f, 0.6f, 0.01f));
        qa.setCoordinate(10, new Point3f(0.4f, 0.8f, 0.01f));
        qa.setCoordinate(11, new Point3f(0.2f, 0.8f, 0.01f));

        qa.setCoordinate(12, new Point3f(0.6f, .60f, 0.01f));
        qa.setCoordinate(13, new Point3f(0.8f, 0.6f, 0.01f));
        qa.setCoordinate(14, new Point3f(0.8f, 0.8f, 0.01f));
        qa.setCoordinate(15, new Point3f(0.6f, 0.8f, 0.01f));

        qa.setCoordinate(16, new Point3f(0f, 1f, 0f));
        qa.setCoordinate(17, new Point3f(0.5f, 1f, 0f));
        qa.setCoordinate(18, new Point3f(0.5f, 1.3f, 0f));
        qa.setCoordinate(19, new Point3f(0f, 1f, 0f));

        qa.setCoordinate(20, new Point3f(1f, 1f, 0f));
        qa.setCoordinate(21, new Point3f(0.5f, 1.3f, 0f));
        qa.setCoordinate(22, new Point3f(0.5f, 1f, 0f));
        qa.setCoordinate(23, new Point3f(1f, 1f, 0f));

        qa.setCoordinate(24, new Point3f(0.1f, 1f, -0.01f));
        qa.setCoordinate(25, new Point3f(0.2f, 1f, -0.01f));
        qa.setCoordinate(26, new Point3f(0.2f, 1.2f, -0.01f));
        qa.setCoordinate(27, new Point3f(0.1f, 1.2f, -0.01f));

        return qa;
    }

    public static TriangleFanArray getTree() {
        int counts[] = {19};


        TriangleFanArray tfa = new TriangleFanArray(19,
                GeometryArray.COORDINATES
                | GeometryArray.COLOR_3,
                counts);

        tfa.setCoordinate(0, new Point3f(0.00f, 0.60f, 0.0f));
        tfa.setCoordinate(1, new Point3f(-0.05f, 0.00f, 0.0f));
        tfa.setCoordinate(2, new Point3f(0.05f, 0.00f, 0.0f));
        tfa.setCoordinate(3, new Point3f(0.05f, 0.25f, 0.0f));
        tfa.setCoordinate(4, new Point3f(0.15f, 0.30f, 0.0f));
        tfa.setCoordinate(5, new Point3f(0.22f, 0.25f, 0.0f));
        tfa.setCoordinate(6, new Point3f(0.18f, 0.40f, 0.0f));
        tfa.setCoordinate(7, new Point3f(0.20f, 0.55f, 0.0f));
        tfa.setCoordinate(8, new Point3f(0.15f, 0.65f, 0.0f));
        tfa.setCoordinate(9, new Point3f(0.14f, 0.80f, 0.0f));
        tfa.setCoordinate(10, new Point3f(0.08f, 0.95f, 0.0f));
        tfa.setCoordinate(11, new Point3f(0.00f, 1.00f, 0.0f));
        tfa.setCoordinate(12, new Point3f(-0.20f, 0.85f, 0.0f));
        tfa.setCoordinate(13, new Point3f(-0.22f, 0.70f, 0.0f));
        tfa.setCoordinate(14, new Point3f(-0.30f, 0.60f, 0.0f));
        tfa.setCoordinate(15, new Point3f(-0.35f, 0.45f, 0.0f));
        tfa.setCoordinate(16, new Point3f(-0.25f, 0.43f, 0.0f));
        tfa.setCoordinate(17, new Point3f(-0.30f, 0.25f, 0.0f));
        tfa.setCoordinate(18, new Point3f(-0.02f, 0.24f, 0.0f));
        return tfa;
    }

    public static Shape3D getTrees() {

        TriangleFanArray tfa = getTree();

        Color3f c = new Color3f(0.1f, 0.9f, 0.0f);
        for (int i = 0; i < 19; i++)
            tfa.setColor(i, c);
        c.set(0.5f, 0.5f, 0.3f);
        tfa.setColor(1, c);
        tfa.setColor(2, c);
        tfa.setColor(18, c);
        return new Shape3D(tfa);
    }

    public static Shape3D getHouses() {

        QuadArray qa = getHouse();

        Color3f c = new Color3f(1f, 1f, 1f);
        Color3f d = new Color3f(0f, 0f, 0f);
        Color3f e = new Color3f(1f, 0f, 0f);
        for (int i = 0; i < 4; i++)
            qa.setColor(i, c);
        for (int i = 4; i < 24; i++)
            qa.setColor(i, d);
        for (int i = 24; i < 28; i++)
            qa.setColor(i, e);

        Shape3D house = new Shape3D(qa);
        return house;
    }
}
