/*
    Earth.java
    Program to display rotating earth
    By Roger T. Stevens  4-5-99
*/
package j3d.cr325;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import j3d.Utils;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import java.applet.Applet;
import java.awt.*;

public class MandelEarth extends Applet {

    public MandelEarth() {
        Canvas3D c = Utils.getCanvas3D(this);
        add(c, BorderLayout.CENTER);
        String img1 = "gifs\\animation1.gif";
        String img2 = "color\\airplane.JPEG";
        BranchGroup bg = Utils.getTextureSphere(0.5,
                0, 0, img2);
        bg.compile();
        SimpleUniverse u = new SimpleUniverse(c);
        u.getViewingPlatform().setNominalViewingTransform();
        u.addBranchGraph(bg);
    }

    public static void main(String[] args) {
        new MainFrame(new MandelEarth(), 700, 700);
    }
}
