/**
 * Created by IntelliJ IDEA.
 * User: jgervasio
 * Date: Feb 23, 2004
 * Time: 12:11:58 PM
 * To change this template use Options | File Templates.
 */
package j3d.cr325;


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import j3d.Utils;

import javax.media.j3d.*;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import java.applet.Applet;


//   BillboardApp renders a simple landscape with billboard animated trees

public class Levitown extends Applet {

    public BranchGroup getSceneBranchGroup(TransformGroup tg) {

        BranchGroup bg = new BranchGroup();

        Vector3f translate = new Vector3f();
        Transform3D t3d = new Transform3D();
        BoundingSphere bs = new BoundingSphere();
        bs.setRadius(10);

        bg.addChild(Shapes.getLand());

        addTrees(translate, t3d, bs, bg);
        addHouses(translate, t3d, bs, bg);

        raiseViewAboveGround(translate, t3d, tg);
        Utils.addKeyboardNavigation(tg, bg);

        bg.addChild(Target.getTargetGroup());
        return bg;
    } // end of CreateSceneGraph method of BillboardApp

    private void raiseViewAboveGround(Vector3f translate, Transform3D t3D, TransformGroup tg) {
        translate.set(0.0f, 0.3f, 0.0f);
        t3D.setTranslation(translate);
        tg.setTransform(t3D);
    }

    private void addHouses(Vector3f translate,
                           Transform3D t3D,
                           BoundingSphere bSphere,
                           BranchGroup bg) {
        SharedGroup share = new SharedGroup();

        share.addChild(Shapes.getHouses());

        float position[][] = {{0.0f, 0f, -2.0f},
                              {3.0f, 0f, 0.0f},
                              {3.0f, 0f, 4.0f},
                              {4.0f, 0f, -8.0f},
                              {6.0f, 0f, -25.0f},
                              {-6.0f, 0f, 25.0f},
                              {-6.0f, 0f, 15.0f},
                              {6.0f, 0f, 1.0f}};

        placeStuff(position, translate, t3D, bSphere, bg, share);
    }

    private void addTrees(Vector3f translate,
                          Transform3D t3D,
                          BoundingSphere bSphere,
                          BranchGroup bg) {
        SharedGroup share = new SharedGroup();
        share.addChild(Shapes.getTrees());

        float position[][] = {{0.0f, 0f, -3.0f},
                              {6.0f, 0f, 0.0f},
                              {6.0f, 0f, 6.0f},
                              {3.0f, 0f, -10.0f},
                              {13.0f, 0f, -30.0f},
                              {-13.0f, 0f, 30.0f},
                              {-13.0f, 0f, 23.0f},
                              {13.0f, 0f, 3.0f}};

        placeStuff(position, translate, t3D, bSphere, bg, share);
    }

    private void placeStuff(float[][] position,
                            Vector3f translate,
                            Transform3D t3D,
                            BoundingSphere bSphere,
                            BranchGroup bg,
                            SharedGroup share) {
        TransformGroup TGT;
        TransformGroup TGR;
        Billboard billboard;
        for (int i = 0; i < position.length; i++) {
            translate.set(position[i]);
            t3D.setTranslation(translate);
            TGT = new TransformGroup(t3D);
            TGR = new TransformGroup();
            TGR.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
            billboard = new Billboard(TGR);
            billboard.setSchedulingBounds(bSphere);
            billboard.setAlignmentMode(Billboard.ROTATE_ABOUT_POINT);
            bg.addChild(TGT);
            bg.addChild(billboard);
            TGT.addChild(TGR);
            TGR.addChild(new Link(share));
        }
    }

    public Levitown() {

        Canvas3D c3d = Utils.getCanvas3D(this);
        add("Center", c3d);
        SimpleUniverse su = new SimpleUniverse(c3d);
        su.addBranchGraph(createBackground(this));

        TransformGroup vpt
                = su.getViewingPlatform().getViewPlatformTransform();

        su.addBranchGraph(getSceneBranchGroup(vpt));
    }

    BoundingSphere getBackgroundBoundingSphere() {
        return new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000.0);
    }

    public static BranchGroup createBackground(Levitown levitown) {
        // create a parent BranchGroup for the Background
        BranchGroup backgroundGroup = new BranchGroup();

        // create a new Background node
        Background back = new Background();

        // set the range of influence of the background
        back.setApplicationBounds(levitown.getBackgroundBoundingSphere());

        // create a BranchGroup that will hold
        // our Sphere geometry
        BranchGroup bgGeometry = new BranchGroup();

        // create the Sphere geometry with radius 1.0
        // we tell the Sphere to generate texture coordinates
        // to enable the texture image to be rendered
        // and because we are *inside* the Sphere we have to generate
        // Normal coordinates inwards or the Sphere will not be visible.
        Appearance appearance = new Appearance();
        appearance.setTexture(Utils.getMandleTexture(640, 480));
        Sphere sphere = new Sphere(.50f,
                Primitive.GENERATE_TEXTURE_COORDS |
                Primitive.GENERATE_NORMALS_INWARD,
                appearance);

        // start wiring everything together
        // add the Sphere to its parent BranchGroup
        bgGeometry.addChild(sphere);


        // assign the BranchGroup to the Background as geometry.
        back.setGeometry(bgGeometry);

        // add the Background node to its parent BranchGroup
        backgroundGroup.addChild(back);

        return backgroundGroup;
    }


    public static void main(String[] args) {
        new MainFrame(new Levitown(), 256, 256);
    } // end of main (method of BillboardApp)
}
