/**
 * Created by IntelliJ IDEA.
 * User: tchuong
 * Date: Feb 18, 2004
 * Time: 2:12:34 PM
 * To change this template use Options | File Templates.
 */
package j3d.cr325.Hello;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import gui.ClosableJFrame;
import gui.run.RunButton;

import javax.media.j3d.*;
import javax.swing.*;
import java.awt.*;

public class VariableSpeedCube {
    public static void main(String[] args) {
        ClosableJFrame cubeFrame = new ClosableJFrame("3d Cube");
        Container c = cubeFrame.getContentPane();
        c.setLayout(new BorderLayout());
        CubePanel cp = new CubePanel();
        ButtonControlPanel bcp = new ButtonControlPanel(cp);
        c.add(cp, BorderLayout.CENTER);
        c.add(bcp, BorderLayout.SOUTH);
        cubeFrame.setSize(600, 600);
        cubeFrame.show();
    }
}//Hello3dFrame

class CubePanel extends JPanel {
    public long alphaTime = 4000;
    public float cubeSize = 0.4f;

    public CubePanel() {
        setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();

        Canvas3D canvas3D = new Canvas3D(config);
        add("Center", canvas3D);

        BranchGroup bg = createSceneGraph();
        bg.compile();

        // SimpleUniverse is a Convenience Utility class
        SimpleUniverse su = new SimpleUniverse(canvas3D);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        su.getViewingPlatform().setNominalViewingTransform();

        su.addBranchGraph(bg);
    } // end of CubePanel (constructor)

    public BranchGroup createSceneGraph() {
        BranchGroup branchGroupRoot
                = new BranchGroup();
        Transform3D rotate
                = new Transform3D();
        Transform3D tempRotate
                = new Transform3D();
        rotate.rotX(Math.PI / 4.0d);
        tempRotate.rotY(Math.PI / 5.0d);
        rotate.mul(tempRotate);

        TransformGroup rotateTransformGroup
                = new TransformGroup(rotate);
        TransformGroup spinTransformGroup
                = new TransformGroup();
        spinTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

        branchGroupRoot.addChild(rotateTransformGroup);
        rotateTransformGroup.addChild(spinTransformGroup);

        // Create a simple shape leaf node, add it to the scene graph.
        // ColorCube is a Convenience Utility
        cc = getColorCube();
        spinTransformGroup.addChild(cc);

        // Create a new Behavior object that will perform the desired
        // operation on the specified transform object and add it into
        // the scene graph.

        ri = getRotationInterpolator(spinTransformGroup);
        si = getScaleInterpolator(spinTransformGroup);
        BoundingSphere bounds = new BoundingSphere();
        ri.setSchedulingBounds(bounds);
        si.setSchedulingBounds(bounds);
        spinTransformGroup.addChild(ri);
        spinTransformGroup.addChild(si);
        return branchGroupRoot;
    }

    ColorCube cc = new ColorCube();

    private ColorCube getColorCube() {
        return new ColorCube(getCubeScale());
    }

    public void setCubeSize(float s) {
        si.setMinimumScale(s);
        si.setMaximumScale(s);
        cubeSize = s;
    }

    public float getCubeScale() {
        return cubeSize;
    }

    RotationInterpolator ri = null;
    ScaleInterpolator si = null;


    private ScaleInterpolator getScaleInterpolator(TransformGroup tg) {
        return new ScaleInterpolator(new Alpha(-1, getAlphaTime()),
                tg,
                new Transform3D(),
                0.0f,
                1f);
    }

    private RotationInterpolator getRotationInterpolator(TransformGroup objSpin) {
        return new RotationInterpolator(new Alpha(-1, getAlphaTime()),
                objSpin,
                new Transform3D(),
                0.0f,
                (float) Math.PI * 2.0f);
    }

    public void setAlphaTime(long num2) {
        alphaTime = num2;
        ri.setAlpha(new Alpha(-1, getAlphaTime()));
    }//setAlphaTime(int)

    public long getAlphaTime() {
        return alphaTime;
    }

}//class CubePanel


class ButtonControlPanel extends JPanel {
    private CubePanel cube;
    private JLabel alphaLabel = new JLabel("a = " + 4000);
    private JLabel scaleLabel = new JLabel("scale = " + .4);

    //--------------------------------------------
    // Sets up the cube control panel
    //--------------------------------------------
    public ButtonControlPanel(CubePanel cubePanel) {
        setLayout(new FlowLayout());
        cube = cubePanel;
        add(alphaLabel);
        add(scaleLabel);

        add(new RunButton("[m") {
            public void run() {
                cube.setAlphaTime(cube.getAlphaTime() - 500);
                alphaLabel.setText("a = " + cube.getAlphaTime());
            }//run
        });

        add(new RunButton("[p") {
            public void run() {
                cube.setAlphaTime(cube.getAlphaTime() + 500);
                alphaLabel.setText("a = " + cube.getAlphaTime());
            }
        });

        add(new RunButton("[s") {
            public void run() {
                cube.setAlphaTime(0);
                alphaLabel.setText("a = " + cube.getAlphaTime());
            }
        });

        add(new RunButton("sm[aller cube") {
            public void run() {
                cube.setCubeSize(cube.getCubeScale() - .1f);
                scaleLabel.setText("scale = " + cube.getCubeScale());
            }
        });

        add(new RunButton("bi[gger cube") {
            public void run() {
                cube.setCubeSize(cube.getCubeScale() + .1f);
                scaleLabel.setText("scale = " + cube.getCubeScale());
            }
        });

    } //end constructor ButtonControlPanel

}//class ButtonControlPanel
