package j3d.cr325.Hello;


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import java.applet.Applet;
import java.awt.*;

//   HelloJava3Dbalt renders a single, rotated cube.

public class HelloJava3Dbalt extends Applet {
    public BranchGroup createSceneGraph() {
        // Create the root of the branch graph
        BranchGroup bg = new BranchGroup();

        // rotate object has composited transformation matrix
        Transform3D rotate = new Transform3D();
        Transform3D tempRotate = new Transform3D();

        rotate.rotX(Math.PI / 4.0d);
        tempRotate.rotY(Math.PI / 5.0d);
        tempRotate.mul(rotate);

        TransformGroup objRotate = new TransformGroup(tempRotate);

        bg.addChild(objRotate);
        objRotate.addChild(new ColorCube(0.4));
        // Let Java 3D perform optimizations on this scene graph.
        bg.compile();

        return bg;
    } // end of CreateSceneGraph method of HelloJava3Dbalt

    // Create a simple scene and attach it to the virtual universe

    public HelloJava3Dbalt() {
        setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();

        Canvas3D canvas3D = new Canvas3D(config);
        add("Center", canvas3D);

        BranchGroup bg = createSceneGraph();

        // SimpleUniverse is a Convenience Utility class
        SimpleUniverse su = new SimpleUniverse(canvas3D);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        su.getViewingPlatform().setNominalViewingTransform();

        su.addBranchGraph(bg);
    } // end of HelloJava3Db (constructor)
    //  The following allows this to be run as an application
    //  as well as an applet

    public static void main(String[] args) {
        new MainFrame(new HelloJava3Dbalt(), 256, 256);
    } // end of main (method of HelloJava3Dbalt)

} // end of class HelloJava3Dbalt
