package j3d;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Mar 3, 2004
 * Time: 5:34:28 PM
 */
/////////////////////////////////////////////////
//
// create Twist visual object
//
public class Twist extends Shape3D {

    ////////////////////////////////////////////
    //
// create twist subgraph
    //
    public Twist() {

        this.setGeometry(createGeometry());
        this.setAppearance(createAppearance());
    } // end of twist constructor

    Geometry createGeometry() {

        TriangleStripArray twistStrip;
        Color3f blue = new Color3f(0.0f, 0.0f, 1.0f);

        // create triangle strip for twist
        int N = 80;
        int stripCounts[] = {N};
        twistStrip = new TriangleStripArray(N,
                TriangleStripArray.COORDINATES | TriangleStripArray.COLOR_3,
                stripCounts);

        double a;
        int v;
        for (v = 0, a = 0.0;
             v < N; v += 2,
                     a = v * 2.0 * Math.PI / (N - 2)) {
            twistStrip.setCoordinate(v, new Point3d(0.7 * Math.sin(a) + 0.2 * Math.cos(a),
                    0.3 * Math.sin(a),
                    0.7 * Math.cos(a) + 0.2 * Math.cos(a)));
            twistStrip.setCoordinate(v + 1, new Point3d(0.7 * Math.sin(a) - 0.2 * Math.cos(a),
                    -0.3 * Math.sin(a),
                    0.7 * Math.cos(a) - 0.2 * Math.cos(a)));
            twistStrip.setColor(v, blue);
            twistStrip.setColor(v + 1, blue);
        }

        return twistStrip;

    }

    // create Appearance for Twist Strip
    //
    // this method creates the default Appearance for the
    // twist strip.  The commented line of code containting
    // the setCullFace will fix the problem of half of the
    // Twisted Strip disappearing.

    Appearance createAppearance() {

        Appearance twistAppear = new Appearance();
        PolygonAttributes polyAttrib = new PolygonAttributes();
        // polyAttrib.setCullFace(PolygonAttributes.CULL_NONE);
        twistAppear.setPolygonAttributes(polyAttrib);

        return twistAppear;
    }

} // end of class Twist
