package j3d;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.image.TextureLoader;

import javax.media.j3d.*;
import java.applet.Applet;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.io.File;

//   SimpleBehaviorApp renders a single ColorCube
//   that rotates when any key is pressed.

public class KeyDrivenImageBox extends Applet {

    public class SimpleBehavior extends Behavior {

        private TransformGroup targetTG;
        private Transform3D rotation = new Transform3D();
        Transform3D rotz = new Transform3D();
        private double angle = 0.0;

        // create SimpleBehavior
        SimpleBehavior(TransformGroup targetTG) {
            this.targetTG = targetTG;
        }

        // initialize the Behavior
        //     set initial wakeup condition
        //     called when behavior beacomes live
        public void initialize() {
            // set initial wakeup condition
            this.wakeupOn(new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED));
        }

        // behave
        // called by Java 3D when appropriate stimulus occures
        public void processStimulus(Enumeration criteria) {
            // decode event

            // do what is necessary
            angle += 0.1;
            rotation.rotY(angle);
            rotz.rotZ(angle * .1);
            rotation.mul(rotz);
            targetTG.setTransform(rotation);
            this.wakeupOn(new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED));
        }

    } // end of class SimpleBehavior

    private Appearance getAppearance() {
        Appearance app = new Appearance();
        //File f = futils.Futil.getReadFile("select env map");
        // load a texture image using the Java 3D texture loader
        //Texture tex = new TextureLoader(f.toString(), this).getTexture();
        // apply the texture to the Appearance

        app.setTexture(Utils.getMandleTexture(400,400));
        return app;
    }

    public BranchGroup createSceneGraph() {
        // Create the root of the branch graph
        BranchGroup objRoot = new BranchGroup();

        TransformGroup objRotate = new TransformGroup();
        objRotate.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

        objRoot.addChild(objRotate);
        Box b = new Box(.4f,.4f,.4f,
                Box.GENERATE_TEXTURE_COORDS,getAppearance());
        objRotate.addChild(b);

        SimpleBehavior myRotationBehavior = new SimpleBehavior(objRotate);
        myRotationBehavior.setSchedulingBounds(new BoundingSphere());
        objRoot.addChild(myRotationBehavior);

        // Let Java 3D perform optimizations on this scene graph.
        objRoot.compile();

        return objRoot;
    } // end of CreateSceneGraph method of SimpleBehaviorApp

    // Create a simple scene and attach it to the virtual universe

    public KeyDrivenImageBox() {
        setLayout(new BorderLayout());

        Canvas3D canvas3D
                = new Canvas3D(
                        SimpleUniverse.getPreferredConfiguration());
        add("Center", canvas3D);
        SimpleUniverse su = new SimpleUniverse(canvas3D);
        BranchGroup scene = createSceneGraph();

        su.getViewingPlatform().setNominalViewingTransform();

        su.addBranchGraph(scene);
    }

    public static void main(String[] args) {
        Frame frame = new MainFrame(new KeyDrivenImageBox(), 256, 256);
    } // end of main (method of SimpleBehaviorApp)

} // end of class SimpleBehaviorApp
