package j2d.lowPass;

import j2d.ImageUtils;
import ip.transforms.Gauss;
import j2d.ImageProcessorInterface;

import java.awt.*;


public class GaussianSmoothingProcessor
        implements ImageProcessorInterface {

    private int kernelWidth;
    private double sigma;


    public GaussianSmoothingProcessor(
            int _kernelWidth,
            double _sigma) {

        kernelWidth = _kernelWidth;
        sigma = _sigma;
    }

    public Image process(Image img) {
        return gaussianSmooth(img);

    }

    private Image gaussianSmooth(Image img) {
        return ImageUtils.convolution(img,
                Gauss.getGaussKernel(
                        kernelWidth,
                        kernelWidth,
                        sigma));
    }

}

