/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Feb 28, 2003
 * Time: 7:44:33 AM
 */
package j2d.hpp;


public class ContrastFilter implements HppFilterInterface {
    private double c, b;

    public ContrastFilter(double _c, double _b) {
        c = _c;
        b = _b;

    }

    public short getR(int r) {
        return contrast(r);
    }

    public short getG(int g) {
        return contrast(g);
    }

    public short getB(int b) {
        return contrast(b);
    }

    private short contrast(double v) {
        v = c * v + b;
        if (v < 0) return 0;
        if (v > 255) return 255;
        return (short) (v);
    }

}
