// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import java.awt.*;
import java.util.Observer;

/**
 * A GUI panel that contains a variable number of identical sliders.
 */
public class ObservableSliderBank extends JPanel {
    private ObservableSlider[] sliders;

    /**
     * Construct a new ObservableSliderBank containing the specified number
     * of sliders.
     *
     * @param nSliders Number of sliders
     */
    public ObservableSliderBank(int nSliders) {
        setLayout(new GridLayout(1, 0, 10, 6));
        setBorder(new EmptyBorder(10, 10, 10, 10));

        sliders = new ObservableSlider[nSliders];

        for (int i = 0; i < nSliders; i++) {
            sliders[i] = new ObservableSlider();
            add(sliders[i]);
        }
    }

    /**
     * Set the label which will be displayed next to a particular
     * slider in the ObservableSliderBank.
     *
     * @param i     Index of the slider
     * @param label Text of the label
     */
    public void setSliderLabel(int i, String label) {
        sliders[i].setLabel(label);
    }

    /**
     * Set the min and max values of a particular slider
     *
     * @param i   Index of the slider
     * @param min Minimum value
     * @param max Maximum value
     */
    public void setSliderRange(int i, float min, float max) {
        sliders[i].setMinimum(min);
        sliders[i].setMaximum(max);
    }

    /**
     * Set a slider as linear or log scale.
     *
     * @param i     Index of the slider
     * @param state True = log; false = linear
     */
    public void setSliderLogScale(int i, boolean state) {
        sliders[i].setLogScale(state);
    }

    /**
     * Set a tick label which will be displayed on a particular
     * slider in the ObservableSliderBank.
     *
     * @param i     Index of the slider
     * @param tick  Position of the label
     * @param label Text of the label
     */
    public void setTickLabel(int i, float tick, String label) {
        sliders[i].setTickLabel(tick, label);
    }

    /**
     * Retrieve an array of values representing the position of
     * all the sliders.
     *
     * @return Array of slider values
     */
    public float[] getValues() {
        float j[] = new float[sliders.length];
        for (int i = 0; i < sliders.length; i++) {
            j[i] = sliders[i].getValue();
        }
        return j;
    }

    /**
     * Set the positions of all the sliders
     *
     * @param values Array of slider values
     */
    public void setValues(float values[]) {
        for (int i = 0; i < sliders.length; i++) {
            sliders[i].setValue(values[i]);
        }
    }

    /**
     * Allows other classes to listen for ActionEvents generated
     * by the ObservableSliderBank.
     *
     * @param o The class that wants to listen
     */
    public void addObserver(Observer o) {
        for (int i = 0; i < sliders.length; i++) {
            sliders[i].addObserver(o);
        }
    }
}

