// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

import j2d.ShortImageBean;

import javax.swing.*;
import java.awt.*;

/**
 * MDI child frame for displaying an image
 */
public class ImageChildFrame extends JInternalFrame {
    private ImagePanel ipnDisplay;
    private Image imgBaseImage;

    /**
     * Construct a new frame with the specified base image and
     * title.
     *
     * @param img   The base image.  This is the intially displayed
     *              image and the one on which signal processing is
     *              performed.
     * @param title Text for the frame's title bar
     */
    public ImageChildFrame(Image img, String title) {
        Container c;
        JScrollPane jsp;

        setTitle(title);

        imgBaseImage = img;

        ipnDisplay = new ImagePanel();
        ipnDisplay.setImage(img);

        c = getContentPane();
        c.setLayout(new BorderLayout());
        jsp = new JScrollPane();
        jsp.setViewportView(ipnDisplay);
        c.add(jsp, BorderLayout.CENTER);

        setMinimumSize(new Dimension(100, 100));
        setClosable(true);
        setMaximizable(true);
        setResizable(true);
    }

    /**
     * Set the displayed image, typically a processed version of the base
     * image generated outside of this class
     *
     * @param img The image to display
     */
    public void setImage(Image img) {
        ipnDisplay.setImage(img);
    }

    /**
     * Obtain a handle to the base image.
     */
    public Image getBaseImage() {
        return imgBaseImage;
    }

    /**
     * Obtain a handle to the displayed image.
     */
    public Image getImage() {
        return ipnDisplay.getImage();
    }
    public void negate() {
        ShortImageBean sib = new ShortImageBean(imgBaseImage);
        sib.negate();
        ipnDisplay.setImage(sib.getImage());
    }
    /**
     * Display the base image.
     */
    public void revert() {
        ipnDisplay.setImage(imgBaseImage);
    }
}