// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * A JInternalFrame containing controls for histogram
 * equalization.
 */
public class HistogramEQToolbox extends JInternalFrame {
    private JRadioButton rbtUniform;
    private JRadioButton rbtExponential;
    private ButtonGroup bgpOptions;
    private JPanel pnlOptions;
    private ObservableSlider sliAlpha;
    private boolean blnExponential;
    private JButton btnApply;

    /**
     * Construct a new HistogramEQToolbox
     */
    public HistogramEQToolbox() {
        Container c;

        setTitle("Histogram EQ");

        rbtUniform = new JRadioButton("Uniform non-adaptive", true);
        rbtExponential = new JRadioButton("Exponential non-adaptive", false);
        bgpOptions = new ButtonGroup();
        bgpOptions.add(rbtUniform);
        bgpOptions.add(rbtExponential);
        pnlOptions = new JPanel(new GridLayout(0, 1));
        pnlOptions.add(rbtUniform);
        btnApply = new JButton("apply");
        pnlOptions.add(btnApply);
        pnlOptions.add(rbtExponential);

        sliAlpha = new ObservableSlider(0.001f, 10f);
        sliAlpha.setTickLabel(0.001f, "0.001");
        sliAlpha.setTickLabel(1f, "1");
        sliAlpha.setTickLabel(5f, "5");
        sliAlpha.setTickLabel(10f, "10");
        sliAlpha.setLabel("alpha");
        sliAlpha.setEnabled(false);
        blnExponential = false;

        c = getContentPane();
        c.setLayout(new FlowLayout());
        c.add(pnlOptions);
        c.add(sliAlpha);

        rbtUniform.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                sliAlpha.setEnabled(false);
                btnApply.setEnabled(true);
                blnExponential = false;
            }
        });
        rbtExponential.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                sliAlpha.setEnabled(true);
                btnApply.setEnabled(false);
                blnExponential = true;
            }
        });

        setMinimumSize(new Dimension(150, 150));
        pack();
        setClosable(true);
        setMaximizable(false);
        setResizable(false);
    }

    /**
     * Return a handle to the Apply button on the control panel.
     *
     * @return A reference to a JButton
     */
    public JButton getButton() {
        return btnApply;
    }

    /**
     * Return a handle to the Alpha slider on the control panel.
     *
     * @return A reference to an ObservableSlider
     */
    public ObservableSlider getSlider() {
        return sliAlpha;
    }

    /**
     * Return the user's selection of exponential or linear
     * histogram EQ.
     *
     * @return True = exponential, false = linear
     */
    public boolean getExponential() {
        return blnExponential;
    }
}
