// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

import javax.swing.*;
import java.awt.*;

/**
 * A JInternalFrame containing sliders for manipulating false
 * colors added to an image.
 */
public class FalseColorToolbox extends JInternalFrame {
    private ObservableSliderBank sbkRGBSliders;

    /**
     * Construct a new FalseColorToolbox.
     */
    public FalseColorToolbox() {
        Container c;

        sbkRGBSliders = new ObservableSliderBank(3);
        sbkRGBSliders.setSliderLabel(0, "Red");
        sbkRGBSliders.setSliderLabel(1, "Green");
        sbkRGBSliders.setSliderLabel(2, "Blue");
        for (int i = 0; i < 3; i++) {
            sbkRGBSliders.setSliderRange(i, 0.01f, 0.4f);
            sbkRGBSliders.setTickLabel(i, 0.01f, "0.01");
            sbkRGBSliders.setTickLabel(i, 0.4f, "0.40");
        }

        c = getContentPane();
        c.setLayout(new BorderLayout());
        c.add(sbkRGBSliders, BorderLayout.CENTER);

        setTitle("False Color");
        setMinimumSize(new Dimension(150, 150));
        pack();
        setClosable(true);
        setMaximizable(false);
        setResizable(false);
    }

    /**
     * Return a handle to the slider bank on the control panel.
     *
     * @return A reference to an ObservableSliderBank
     */
    public ObservableSliderBank getSliderBank() {
        return sbkRGBSliders;
    }
}
