// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

import javax.swing.*;
import java.awt.*;

/**
 * A JInternalFrame containing controls for performing exponential
 * stretching of an image's brightness.
 */
public class ExponentialStretchToolbox extends JInternalFrame {
    private ObservableSlider sliPower;

    /**
     * Construct a new ExponentialStretchToolbox.
     */
    public ExponentialStretchToolbox() {
        Container c;

        sliPower = new ObservableSlider(0.125f, 8.0f);
        sliPower.setLabel("power");
        sliPower.setTickLabel(0.125f, "0.125");
        sliPower.setTickLabel(1f, "1");
        sliPower.setTickLabel(8f, "8");

        c = getContentPane();
        c.setLayout(new FlowLayout());
        c.add(sliPower);

        setTitle("Exponential Stretch");
        setMinimumSize(new Dimension(150, 150));
        pack();
        setClosable(true);
        setMaximizable(false);
        setResizable(false);
    }

    /**
     * Return a handle to the Power slider on the control panel.
     *
     * @return A reference to an ObservableSlider
     */
    public ObservableSlider getSlider() {
        return sliPower;
    }
}
