package j2d.edge;

import gui.run.RunButton;
import gui.run.RunCheckBox;
import gui.run.RunSlider;
import j2d.*;
import j2d.animation.AnimationDialog;

import javax.swing.*;
import java.awt.*;


public class LoGSobelPanel extends JPanel {


    private int kernelWidth = 19;
    private double sigma = 2.0;
    private int thresh = 128;
    private boolean isThresh = true;
    private boolean isSobel = true;

    ImageProcessListener ipl = null;

    /**Construct the frame*/
    public LoGSobelPanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        initGuiElements();

    }

    private JPanel getFlowPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        return jp;
    }

    /**Component initialization*/
    private void initGuiElements() {
        setLayout(new GridLayout(0, 2));

        add(new JLabel("kernel width"));
        add(new RunSlider(4, 19, 19) {
            public void run() {
                kernelWidth = getValue();
            }
        });
        add(new JLabel("thresh"));
        add(new RunSlider(4, 255, 128) {
            public void run() {
                thresh = getValue();
            }
        });

        add(getFlowComponents());

    }

    private JPanel getFlowComponents() {
        JPanel jp = getFlowPanel();
        jp.add(new RunCheckBox("thresh", true) {
            public void run() {
                isThresh = isSelected();
            }
        });
        jp.add(new RunCheckBox("sobel", true) {
            public void run() {
                isSobel = isSelected();
            }
        });
        jp.add(new RunButton("comparison") {
            public void run() {
                ImageProcessorFactory ipf =
                        new AnimationProcessor(
                        );
                ComparisonUtils.showComparisonFrame(
                        getComparisonPanel(ipf));
            }
        });
        jp.add(new RunButton("save Gifs") {
            public void run() {
                saveGifs(new LoGSobelProcessor(
                        kernelWidth,
                        sigma, thresh,
                        isThresh, isSobel));
            }
        });

        jp.add(new RunButton("apply") {
            public void run() {
                updateImage();
            }
        });
        jp.add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        return jp;
    }

    class AnimationProcessor
            extends LoGSobelProcessor {
        public RunButton getButton() {
            return
                    new RunButton("save Gifs") {
                        public void run() {
                            saveGifs();
                        }
                    };
        }

        AnimationProcessor() {
            super(kernelWidth,
                    sigma,
                    thresh,
                    isThresh,
                    isSobel);
        }

        public ImageProcessorInterface getProcessor(int i) {
            return
                    new LoGSobelProcessor(
                            kernelWidth,
                            i,
                            thresh,
                            isThresh, isSobel);
        }

        public void saveGifs() {
            ImageBeanInterface origImagePanel =
                    (ImageBeanInterface) ipl;
            new AnimationDialog(origImagePanel.getImage(),
                    this);
        }
    }

    public JPanel getComparisonPanel(ImageProcessorFactory ipf) {

        ImageBeanInterface origImagePanel = (ImageBeanInterface) ipl;
        Image sourceImage = origImagePanel.getImage();
        return ComparisonUtils.getComparisonPanel(sourceImage, ipf);

    }

    public void saveGifs(ImageProcessorFactory ipf) {
        ImageBeanInterface origImagePanel =
                (ImageBeanInterface) ipl;
        new AnimationDialog(origImagePanel.getImage(),
                ipf);
    }

    public void updateImage() {
        try {
            ipl.update(new LoGSobelProcessor(
                    kernelWidth,
                    sigma, thresh, isThresh, isSobel
            ));
        } catch (Exception e) {
            System.out.println("ER!:kernelWidth=" + kernelWidth);
        }
    }


}
