package j2d.edge;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.ComparisonUtils;
import j2d.ImageBeanInterface;
import j2d.ImageProcessListener;
import j2d.ImageProcessorFactory;
import j2d.animation.AnimationDialog;

import javax.swing.*;
import java.awt.*;


public class CannyPanel extends JPanel {


    private int widGaussianKernel = 15;
    private int thresh1 = 50;
    private int thresh2 = 230;
    private int thresh = 128;
    private float sigma = 1.0f;


    ImageProcessListener ipl = null;

    /**Construct the frame*/
    public CannyPanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        initGuiElements();

    }

    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("apply") {
            public void run() {
                updateImage();
            }
        });
        jp.add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        jp.add(new RunButton("comparison") {
            public void run() {
                ImageProcessorFactory ipf = new CannyProcessor(
                        thresh1,
                        thresh2,
                        thresh,
                        widGaussianKernel,
                        sigma);
                ComparisonUtils.showComparisonFrame(
                        getComparisonPanel(ipf));
            }
        });
        jp.add(new RunButton("save gifs") {
            public void run() {
                saveGifs();
            }
        });
        return jp;
    }

    private void saveGifs() {
        ImageProcessorFactory ipf = new CannyProcessor(
                thresh1,
                thresh2,
                thresh,
                widGaussianKernel,
                sigma);

        ImageBeanInterface origImagePanel =
                (ImageBeanInterface) ipl;
        new AnimationDialog(origImagePanel.getImage(),
                ipf);


    }

    /**Component initialization*/
    private void initGuiElements() {
        RunSlider rs[] = {
            RunSlider.getLabeledSlider("kernel",
                    new RunSlider(3, 40, 15) {
                        public void run() {
                            widGaussianKernel = getValue();
                        }
                    }),

            RunSlider.getLabeledSlider("sigma",
                    new RunSlider(1, 10, 1) {
                        public void run() {
                            sigma = getValue();
                        }
                    }),


            RunSlider.getLabeledSlider("Thresh1",
                    new RunSlider(1, 255, thresh1) {
                        public void run() {
                            thresh1 = getValue();
                        }
                    }),

            RunSlider.getLabeledSlider("Thresh2",
                    new RunSlider(1, 255, thresh2) {
                        public void run() {
                            thresh2 = getValue();
                        }
                    }),

            RunSlider.getLabeledSlider("Threshold",
                    new RunSlider(1, 255, 128) {
                        public void run() {
                            thresh = getValue();
                        }
                    }),

        };
        JPanel labelPanel = new JPanel();
        JPanel sliderPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        sliderPanel.setLayout(new GridLayout(0, 1));
        for (int i = 0; i < rs.length; i++) {
            labelPanel.add(rs[i].getValueLabel());
            sliderPanel.add(rs[i]);
        }
        setLayout(new BorderLayout());
        add(labelPanel, BorderLayout.EAST);
        add(sliderPanel, BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);

    }

    public JPanel getComparisonPanel(ImageProcessorFactory ipf) {

        ImageBeanInterface origImagePanel =
                (ImageBeanInterface) ipl;
        Image sourceImage = origImagePanel.getImage();
        return ComparisonUtils.getComparisonPanel(
                sourceImage, ipf);

    }


    public void updateImage() {
        ipl.update(new CannyProcessor(
                thresh1,
                thresh2,
                thresh,
                widGaussianKernel,
                sigma
        ));
    }


}
