package j2d;

import gui.Clipper;
import ip.transforms.Kernels;
import math.MathUtils;

import java.awt.*;

/**
 * GPL code by DocJava, Inc.
 * User: lyon
 * Date: Mar 5, 2003
 * Time: 5:44:03 PM
 *
 */
public class ShortImageBean {
    private short r[][];
    private short g[][];
    private short b[][];

    private Clipper clipper = new Clipper();

    public ShortImageBean() {
    }

    public ShortImageBean getImageFlowBean() {
        float ns[][] = Kernels.getRobinson1();
        float ew[][] = Kernels.getRobinson3();
        Image maxImage = getImage();
        ShortImageBean nsb =
                new ShortImageBean(
                        ImageUtils.convolution(maxImage, ns));
        ShortImageBean ewb =
                new ShortImageBean(
                        ImageUtils.convolution(maxImage, ew));
        short imaginaryPart[][] = nsb.getR();
        short realPart[][] = ewb.getR();
        int w = realPart.length;
        int h = realPart[0].length;
        ShortImageBean ifb = new ShortImageBean(w, h);
        short rIfb[][] = ifb.getR();
        int length = 1;
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                double dy = imaginaryPart[x][y];
                double dx = realPart[x][y];
                // y = mx+b,b=y-m*x
                //double b = y - x* dy/dx ;
                //double x1=x+5;
                //double y1=dy/dx * (x+5) + b;
                dy = dy / dx;


                if ((x % length) != 0) continue;
                if ((y % length) != 0) continue;

                if (x + length >= w) continue;
                if (y + length * dy >= h) continue;
                // use DDA to draw a short line segment
                for (int i = 0; i < length; i++)
                    rIfb[x + i][(int) (y + i * dy)] = 255;


            }
        ifb.copyRedToGreenAndBlue();
        return ifb;
    }

    /**
     * average averages the input short image bean with the given
     * short image bean
     * <code>
     * ShortImageBean sib, sib2;
     * sib.average(sib2);
     * This is like:
     * a = avg(a,b);
     * </code>
     * @param sib
     */
    public void average(ShortImageBean sib) {
        for (int x = 0; x < getWidth(); x++)
            for (int y = 0; y < getHeight(); y++) {
                r[x][y] =
                        (short) ((r[x][y] + sib.getR()[x][y]) / 2);
                g[x][y] =
                        (short) ((g[x][y] + sib.getG()[x][y]) / 2);
                b[x][y] =
                        (short) ((b[x][y] + sib.getB()[x][y]) / 2);
            }
    }

    public ShortImageBean(int w, int h) {
        r = new short[w][h];
        g = new short[w][h];
        b = new short[w][h];
    }

    public static ShortImageBean
            getShortImageBean(ShortImageBean sib) {
        int w = sib.getWidth();
        int h = sib.getHeight();
        ShortImageBean nsib = new ShortImageBean(w, h);
        short _r[][] = nsib.getR();
        short _g[][] = nsib.getG();
        short _b[][] = nsib.getB();
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                _r[x][y] = sib.getR()[x][y];
                _g[x][y] = sib.getG()[x][y];
                _b[x][y] = sib.getB()[x][y];
            }

        return nsib;
    }

    public Clipper getClipper() {
        return clipper;
    }

    public int getWidth() {
        return r.length;
    }

    public int getHeight() {
        return r[0].length;
    }

    public ShortImageBean(Image img) {
        setImage(img);
    }

    public Image getImage() {
        return ImageUtils.getImage(r, g, b);
    }

    public void setImage(Image img) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        short[][] r1 = new short[w][h];
        r = r1;
        short[][] g1 = new short[w][h];
        g = g1;
        short[][] b1 = new short[w][h];
        b = b1;
        ImageUtils.pelsToShort(r, g, b,
                ImageUtils.getPels(
                        img,
                        w,
                        h),
                w, h);
    }

    public void gray() {
        for (int x = 0; x < getWidth(); x++)
            for (int y = 0; y < getHeight(); y++) {
                r[x][y] = (short)
                        ((r[x][y] + g[x][y] + b[x][y]) / 3);
                g[x][y] = r[x][y];
                b[x][y] = r[x][y];
            }
    }

    /*
   public void colorToRed2() {
       for (int x = 0; x < getImageWidth(); x++)
           for (int y = 0; y < getImageHeight(); y++)
               getR()[x][y] = (short)
                       ((getR()[x][y] + getG()[x][y] + getB()[x][y]) / 3);
   }
   */
    /**
     * Copy all colors to red plane, using an average
     * operation.
     * <code>
     * ShortImageBean.colorToRed(sib);
     * r = (r+g+b)/3;
     *
     * </code>
     * @param sib
     */
    public static void colorToRed(ShortImageBean sib) {
        for (int x = 0; x < sib.getWidth(); x++)
            for (int y = 0; y < sib.getHeight(); y++)
                sib.r[x][y] = (short)
                        ((sib.r[x][y] +
                        sib.g[x][y] +
                        sib.b[x][y]) / 3);
    }

    public static void clip(ShortImageBean sib) {
        int w = sib.getWidth();
        int h = sib.getHeight();
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                if (sib.r[x][y] > 255) sib.r[x][y] = 255;
                if (sib.g[x][y] > 255) sib.g[x][y] = 255;
                if (sib.b[x][y] > 255) sib.b[x][y] = 255;
                if (sib.r[x][y] < 0) sib.r[x][y] = 0;
                if (sib.g[x][y] < 0) sib.g[x][y] = 0;
                if (sib.b[x][y] < 0) sib.b[x][y] = 0;
            }
    }

    public void saltAndPepper(int n) {
        for (int i = 0; i < n; i++) {
            int rx = MathUtils.rand(0, getWidth() - 1);
            int ry = MathUtils.rand(0, getHeight() - 1);
            r[rx][ry] = 255;
            g[rx][ry] = 255;
            b[rx][ry] = 255;
            rx = MathUtils.rand(0, getWidth() - 1);
            ry = MathUtils.rand(0, getHeight() - 1);
            r[rx][ry] = 0;
            g[rx][ry] = 0;
            b[rx][ry] = 0;
        }
    }

    public void add(int n) {
        for (int x = 0; x < getWidth(); x++)
            for (int y = 0; y < getHeight(); y++) {
                r[x][y] = (short) (r[x][y] + n);
                g[x][y] = (short) (g[x][y] + n);
                b[x][y] = (short) (b[x][y] + n);
            }
    }

    public void negate() {
        for (int x = 0; x < getWidth(); x++)
            for (int y = 0; y < getHeight(); y++) {
                r[x][y] = (short) (255 - r[x][y]);
                g[x][y] = (short) (255 - g[x][y]);
                b[x][y] = (short) (255 - b[x][y]);
            }
        clip(this);
    }

    public void copyRedToGreenAndBlue() {
        g = new short[getWidth()][getHeight()];
        b = new short[getWidth()][getHeight()];
        for (int x = 0; x < getWidth(); x++)
            for (int y = 0; y < getHeight(); y++) {
                g[x][y] = r[x][y];
                b[x][y] = r[x][y];
            }
    }

    public static void subtract(ShortImageBean sibA, ShortImageBean sibB) {
        for (int i = 0; i < sibB.getWidth(); i++)
            for (int j = 0; j < sibB.getHeight(); j++) {
                sibA.r[i][j] = (short) (sibA.r[i][j]
                        - sibB.r[i][j]);
                sibA.g[i][j] = (short) (sibA.g[i][j]
                        - sibB.g[i][j]);
                sibA.b[i][j] = (short) (sibA.b[i][j]
                        - sibB.b[i][j]);
            }
    }

    public int getAverage(int x, int y) {
        return (r[x][y] + g[x][y] + b[x][y]) / 3;
    }

    public short[][] getR() {
        return r;
    }

    public void setR(short[][] r) {
        this.r = r;
    }

    public short[][] getG() {
        return g;
    }

    public void setG(short[][] g) {
        this.g = g;
    }

    public short[][] getB() {
        return b;
    }

    public void setB(short[][] b) {
        this.b = b;
    }
}