// ImagePanel.java
// ImagePanel contains an image for display.  The image is
// converted to a BufferedImage for filtering purposes.
package j2d;

// Java core packages

import gui.run.RunButton;

import java.awt.*;


public class ImageProcessButton
        extends RunButton
        implements
        ImageProcessListener,
        ImageBeanInterface {

    private Image originalImage;
    private Image processedImage;
    private FlowLayout lm = new FlowLayout();

    public Image getProcessedImage() {
        return processedImage;
    }

    public static ImageProcessButton[] getButtons(Image[] ia) {
        ImageProcessButton ipb[] = new ImageProcessButton[ia.length];
        for (int i = 0; i < ia.length; i++)
            ipb[i] = new ImageProcessButton(ia[i]);
        return ipb;
    }

    // ImagePanel constructor
    public ImageProcessButton(Image _img) {
        super("ok");
        originalImage = _img;
        processedImage = _img;

        setSize(_img.getWidth(null), _img.getHeight(null));


    } // end ImagePanel constructor


    public void update(ImageProcessorInterface ip) {
        if (ip == null) {
            setImage(originalImage);
            return;
        }
        System.out.println("ip=" + ip);
        processedImage = ip.process(originalImage);
        repaint();
    }

    public void run() {
        new ImageTabbedFrame(this);
    }

    public void revert() {
        processedImage = originalImage;
    }


    // draw ImagePanel
    public void paint(Graphics g) {
        Dimension d = getSize();
        Image img = processedImage;
        int w = d.width;
        int h = d.height;
        if (img == null) return;
        g.drawImage(img, 0, 0, w, h, this);
    }

    // get preferred ImagePanel size

    public Dimension getMinimumSize() {
        return new Dimension(originalImage.getWidth(this) / 10,
                originalImage.getHeight(this) / 10);
    }

    public Dimension getMaximumSize2() {
        return new Dimension(originalImage.getWidth(this),
                originalImage.getHeight(this));
    }

    public Dimension getPreferredSize() {
        return new Dimension(originalImage.getWidth(this),
                originalImage.getHeight(this));
    }


    public Image getImage() {
        return originalImage;
    }

    public void setImage(Image image) {
        originalImage = image;
        processedImage = image;
        repaint();
    }
}


