// ImagePanel.java
// ImagePanel contains an image for display.  The image is
// converted to a BufferedImage for filtering purposes.
package j2d;

// Java core packages

import javax.swing.*;
import java.awt.*;
import java.awt.image.ImageObserver;

public class ImagePanel
        extends JPanel
        implements ImageProcessListener,
        ImageBeanInterface {

    private Image originalImage;
    private Image processedImage;

    public Image getProcessedImage() {
        return processedImage;
    }


    // ImagePanel constructor
    public ImagePanel(Image _img) {
        originalImage = _img;
        processedImage = _img;

        ImageUtils.waitForImage(this, getImage());

    } // end ImagePanel constructor


    public void update(ImageProcessorInterface ip) {
        if (ip == null) {
            setImage(originalImage);
            return;
        }
        processedImage = ip.process(originalImage);
        repaint();
    }

    public void revert() {
        processedImage = originalImage;
    }


    // draw ImagePanel
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = getSize();
        ImageObserver io = this;
        Image img = processedImage;
        int w = d.width;
        int h = d.height;
        g.drawImage(img, 0, 0, w, h, io);
    }

    // get preferred ImagePanel size
    public Dimension getPreferredSize() {
        return new Dimension(originalImage.getWidth(this),
                originalImage.getHeight(this));
    }


    public Image getImage() {
        return originalImage;
    }

    public void setImage(Image image) {
        originalImage = image;
        processedImage = image;
        repaint();
    }
}


