package j2d;

import futils.Futil;
import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.io.FileNotFoundException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Mar 22, 2004
 * Time: 2:22:10 PM
 */
public class Hoganizer {
    public static void main(String[] args) {
        try {
            Image img = getImage();
            displayImage(img);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void displayImage(Image img){
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(getImagePanel(img));
        c.setLayout(new GridLayout(1,0));
        cf.setSize(200,200);
        cf.show();
    }
    public static JPanel getImagePanel(final Image img){
        return new JPanel() {
            public Dimension getPreferredSize() {
                return new Dimension(
                        img.getHeight(this),
                        img.getWidth(this));
            }
            public void paint(Graphics g){
                Dimension d = getSize();
                int w = d.width;
                int h = d.height;
                g.drawImage(img,0,0,w,h,this);
            }
        };
    }
    public static Image getImage() throws FileNotFoundException {
        File f = Futil.getReadFile("enter a gif or jpeg");
        return ImageUtils.getImage(f);
    }

}
