/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 2, 2003
 * Time: 5:12:56 PM
 */
package j2d;

import graphics.GifUtils;
import graphics.draw2d.DrawTest;
import gui.run.RunButton;
import j2d.hpp.InvertFilter;

import javax.swing.*;
import java.awt.*;

public class FilePanel
        extends JPanel {

    ImageProcessListener ipl = null;
    DrawTest dt = null;

    JPanel getButtonControlPanel() {
        JPanel bcp = new JPanel();
        bcp.setLayout(new FlowLayout());
        bcp.add(new RunButton("[open") {
            public void run() {
                ipl.setImage(ImageUtils.getImage());
            }
        });
        bcp.add(new RunButton("open [gif animation") {
            public void run() {
                Image img[] = GifUtils.getGifs();
                ipl.setImage(ImageUtils.getImage());
            }
        });
        bcp.add(new RunButton("o[riginal") {
            public void run() {
                ipl.update(null);
            }
        });
        bcp.add(new RunButton("[negate") {
            public void run() {
                ipl.update(InvertFilter.getProcessor());
            }
        });
        bcp.add(new RunButton("setRO[I") {
            public void run() {
                dt =
                        new DrawTest("set roi");
                dt.setImage(ipl.getImage());
                dt.setVisible(true);
            }
        });
        bcp.add(new RunButton("getROI") {
            public void run() {
                if (dt == null) return;
                System.out.println(
                        dt.getRoi());
            }
        });
        return bcp;
    }

    FilePanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        setLayout(new BorderLayout());
        add(getButtonControlPanel(),BorderLayout.CENTER);

    }

}
