package ip.transforms;


import java.awt.*;
import java.util.Enumeration;
import java.util.Vector;


public class Polygons {
    private Vector v = new Vector();
    private Enumeration e = null;

    public void addElement(Polygon p) {
        v.addElement(p);
    }

    public void removeElementAt(int i) {
        v.removeElementAt(i);
    }

    public Polygon elementAt(int i) {
        return (Polygon) v.elementAt(i);
    }

    public boolean hasMore() {
        return e.hasMoreElements();
    }

    public Polygon next() {
        if (e == null) e = getEnumeration();
        if (!hasMore()) return null;
        return (Polygon) e.nextElement();
    }

    private Enumeration getEnumeration() {
        return v.elements();
    }

    public int size() {
        return v.size();
    }

    public void drawPolys(Graphics g) {
        g.setColor(Color.green);
        Polygon p;
        for (int i = 0; i < v.size(); i++) {
            p = (Polygon) v.elementAt(i);
            g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
        }
    }

    public void listPolys() {
        for (int i = 0; i < v.size(); i++)
            printPoly((Polygon) v.elementAt(i));
    }

    private void printPoly(Polygon p) {
        System.out.println("i x y");
        int n = p.npoints;
        for (int i = 0; i < n - 1; i++)
            System.out.println(i + " " + p.xpoints[i] + " " + p.ypoints[i]);
        System.out.println(n - 1 + " " + p.xpoints[n - 1] + " " + p.ypoints[n - 1]);
    }

    public static void drawPoly(Graphics g, Polygon p) {
        g.setColor(Color.green);
        g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
    }

    public void polyStats() {
        int numberOfPolys = size();
        Polygon p;
        int n = 0;
        int maxN = 0;
        int minN = 10000;
        for (int i = 0; i < numberOfPolys; i++) {
            p = (Polygon) elementAt(i);
            n += p.npoints;
            if (p.npoints > maxN) maxN = p.npoints;
            if (p.npoints < minN) minN = p.npoints;
        }

        int avgSize = n / numberOfPolys;
        System.out.println("numberOfPolys=" + numberOfPolys);
        System.out.println("numberOfPoints=" + n);
        System.out.println("avgSize=" + avgSize);
        System.out.println("maxN=" + maxN);
        System.out.println("minN=" + minN);
    }


}



