/*
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Aug 2, 2002
 * Time: 8:34:50 AM
 */
package ip.martelli;

import java.util.Observable;

/**
 *  Heuristic cost matrix is computed using weights that
 * are set from an instance of the MartelliParams
 */

public class MartelliParams extends Observable {

    private double ply = 0.5;
    private double greediness = 1.0;
    private double pixel = 1.0;
    // The following number is image specific.
    // Martelli only finds one countour at a time.
    // on multiple runs, you will
    // alter the following.
    public static final int maximumNumberOfEdges = 15000;
    public static final int edgeLength = 20;
    // *I have set the search time here, ------\/  - DL
    public static final int runTimeInSeconds = 10;


    public double getPly() {
        return ply;
    }

    private void changed() {
        super.setChanged();
        super.notifyObservers();
    }

    public void setPly(double ply) {
        this.ply = ply;
        changed();
    }

    public double getGreediness() {
        return greediness;
    }

    public void setGreediness(double greediness) {
        this.greediness = greediness;
        changed();
    }

    public double getPixel() {
        return pixel;
    }

    public void setPixel(double pixel) {
        this.pixel = pixel;
        changed();
    }


}
