// SharpenFilter.java
// SharpenFilter is an Java2DImageFilter that sharpens the edges
// in a BufferedImage.
package ip.j2d;

// Java core packages

import ip.transforms.BufferedImageProcessor;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class SharpenFilter implements BufferedImageProcessor {

    // apply edge-sharpening filter to BufferedImage
    public BufferedImage process(BufferedImage image) {
        // array used to detect edges in image
        float[] sharpenMatrix = {
            0.0f, -1.0f, 0.0f,
            -1.0f, 5.0f, -1.0f,
            0.0f, -1.0f, 0.0f};

        // create filter to sharpen edges
        BufferedImageOp sharpenFilter =
                new ConvolveOp(new Kernel(3, 3, sharpenMatrix),
                        ConvolveOp.EDGE_NO_OP, null);

        // apply sharpenFilter to displayImage
        return sharpenFilter.filter(image, null);

    } // end method processImage
}

