package ip.j2d;

import ip.transforms.BufferedImageProcessor;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Main extends JFrame {

    private JMenu filterMenu;
    private ImagePanel imagePanel = new ImagePanel(
            futils.Futil.getReadFile("select an image"));

    // image filters
    private BufferedImageProcessor invertFilter = new InvertFilter();
    private BufferedImageProcessor sharpenFilter = new SharpenFilter();
    private BufferedImageProcessor blurFilter = new BlurFilter();
    private BufferedImageProcessor colorFilter = new ColorFilter();


    // initialize JMenuItems
    public Main() {
        super("Java 2D Image Processing Demo");

        // initialize ImagePanel
        initGui();

    } // end Java2DExample constructor

    private void initGui() {

        // create JMenuBar
        JMenuBar menuBar = new JMenuBar();
        setJMenuBar(menuBar);

        // create JMenu
        filterMenu = new JMenu("Image Filters");
        filterMenu.setMnemonic('I');

        // create JMenuItem for displaying orginal Image
        JMenuItem originalMenuItem =
                new JMenuItem("Display Original");
        originalMenuItem.setMnemonic('O');

        originalMenuItem.addActionListener(
                new ActionListener() {

                    // show original Image
                    public void actionPerformed(ActionEvent action) {
                        imagePanel.displayOriginalImage();
                    }

                } // end anonymous inner class
        );

        // create JMenuItems for Java2DImageFilter
        JMenuItem invertMenuItem = createMenuItem(
                "Invert", 'I', invertFilter);
        JMenuItem sharpenMenuItem = createMenuItem(
                "Sharpen", 'S', sharpenFilter);
        JMenuItem blurMenuItem = createMenuItem(
                "Blur", 'B', blurFilter);
        JMenuItem changeColorsMenuItem = createMenuItem(
                "Change Colors", 'C', colorFilter);

        // add JMenuItems to JMenu
        filterMenu.add(originalMenuItem);
        filterMenu.add(invertMenuItem);
        filterMenu.add(sharpenMenuItem);
        filterMenu.add(blurMenuItem);
        filterMenu.add(changeColorsMenuItem);

        // add JMenu to JMenuBar
        menuBar.add(filterMenu);

        Container c = getContentPane();
        c.add(imagePanel, BorderLayout.CENTER);
    }


    // create JMenuItem and ActionListener for given filter
    public JMenuItem createMenuItem(String menuItemName,
                                    char mnemonic,
                                    final BufferedImageProcessor filter) {
        // create JMenuItem
        JMenuItem menuItem = new JMenuItem(menuItemName);

        // set Mnemonic
        menuItem.setMnemonic(mnemonic);

        menuItem.addActionListener(
                new ActionListener() {

                    // apply Java2DImageFilter when MenuItem accessed
                    public void actionPerformed(ActionEvent action) {
                        imagePanel.applyFilter(filter);
                    }

                } // end anonymous inner class
        );

        return menuItem;

    } // end method createMenuItem

    // start program
    public static void main(String args[]) {
        Main m = new Main();
        m.setDefaultCloseOperation(EXIT_ON_CLOSE);
        m.pack();
        m.setVisible(true);
    }
}


