// ColorFilter.java
// ColorFilter is an Java2DImageFilter that alters the
// RGB color bands in a BufferedImage.
package ip.j2d;

// Java core packages

import j2d.ImageUtils;
import ip.transforms.BufferedImageProcessor;

import java.awt.image.BufferedImage;

public class ColorFilter implements BufferedImageProcessor {

    // apply color-change filter to BufferedImage
    public BufferedImage process(BufferedImage bi) {
        // create array used to change RGB color bands
        float[][] colorMatrix = {
            {1f, 0f, 0f},
            {0.5f, 1.0f, 0.5f},
            {0.2f, 0.4f, 0.6f}};

        return ImageUtils.changeColors(colorMatrix, bi);


    } // end method processImage

}


