package ip.hak;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;


public class SmallImageFrame extends ip.gui.frames.ClosableFrame implements MouseListener, MouseMotionListener {
    Image im;
    FileDialog fd;
    int col, row;
    P4 p4[][];
    Polygon sp[];
    Polygon dp[];


    public static void main(String args[]) {
        SmallImageFrame sif = new SmallImageFrame("Test");
        sif.setSize(220, 230);
        sif.init();
        sif.setVisible(true);
    }

    public void init() {
        //loadFile();
        QuestionDialog qd = new QuestionDialog(this, "Enter row & colum");
        qd.makeDialog();
        col = qd.getColum() + 1;
        row = qd.getRow() + 1;
        int sz = (col - 1) * (row - 1);
        sp = new Polygon[sz];
        dp = new Polygon[sz];
        initPoints();
        addMouseListener(this);
        addMouseMotionListener(this);
    }

    public void getPoly(Polygon[] pol) {
        int i = 0;
        int n = 4;
        for (int x = 0; x < col - 1; x++)
            for (int y = 0; y < row - 1; y++) {
                int xps[] = new int[n];
                int yps[] = new int[n];

                xps[0] = p4[x][y].getCenter().x - 10;
                xps[1] = p4[x + 1][y].getCenter().x - 10;
                xps[2] = p4[x + 1][y + 1].getCenter().x - 10;
                xps[3] = p4[x][y + 1].getCenter().x - 10;

                yps[0] = p4[x][y].getCenter().y - 30;
                yps[1] = p4[x + 1][y].getCenter().y - 30;
                yps[2] = p4[x + 1][y + 1].getCenter().y - 30;
                yps[3] = p4[x][y + 1].getCenter().y - 30;

                for (int it = 0; it < 4; it++) {
                    System.out.print("(" + xps[it] + " ," + yps[it] + ")  ");
                }
                System.out.println("");

                pol[i++] = new Polygon(xps, yps, n);
            }
    }

    public Polygon[] getSourcePoly() {
        return sp;
    }

    public Polygon[] getDestPoly() {
        getPoly(dp);
        return dp;
    }

    public void loadFile() {
        fd = new FileDialog(new Frame(), "Select Image File", 0);
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname == null)
            return;
        String fdir = fd.getDirectory();
        im = Toolkit.getDefaultToolkit().getImage(fdir + fname);
        repaint();
    }

    public SmallImageFrame(String title) {
        super(title);
    }

    public void loadImage(Image img) {
        im = img;
        waitForImage(this, im);
        int sx = im.getWidth(this);
        int sy = im.getHeight(this);

        setSize(sx + 20, sy + 40);
        repaint();
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (!tracker.checkID(0))
                System.out.println("Load failure!");
        } catch (InterruptedException e) {
        }
    }

    public void initPoints() {
        setLayout(null);
        Point p;
        Dimension d = getSize();
        int gap = 10;
        int xg = (d.width - 2 * gap) / (col - 1);
        int yg = (d.height - gap - 30) / (row - 1);
        int xp = gap;
        int yp;
        p4 = new P4[col][row];

        for (int x = 0; x < col; x++) {
            yp = 30;
            for (int y = 0; y < row; y++) {
                p = new Point(xp, yp);
                p4[x][y] = new P4(p, x, y);

                Point cen = p4[x][y].getCenter();

                add(p4[x][y]);
                Dimension pd = p4[x][y].getPreferredSize();
                p4[x][y].setSize(pd.width, pd.height);
                p4[x][y].setLocation(new Point(p.x - pd.width / 2, p.y - pd.height / 2));
                yp += yg;
            }
            xp += xg;
        }
        repaint();
        getPoly(sp);
    }

    public void paint(Graphics g) {
        if (im == null)
            return;

        Dimension d = getSize();
        g.drawImage(im, 10, 30, d.width - 20, d.height - 40, this);
        super.paint(g);
        if (p4 != null) {
            // Draw Vertical Lines
            for (int y = 0; y < p4[0].length - 1; y++) {
                for (int x = 0; x < p4.length; x++) {
                    Point p1 = p4[x][y].getCenter();
                    Point p2 = p4[x][y + 1].getCenter();
                    g.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
            }

            // Draw Horizontal Lines
            for (int y = 0; y < p4[0].length; y++) {
                for (int x = 0; x < p4.length - 1; x++) {
                    Point p1 = p4[x][y].getCenter();
                    Point p2 = p4[x + 1][y].getCenter();
                    g.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
            }
        }
    }

    public Point getIndex(int x, int y) {
        Point p = new Point(x, y);

        for (int i = 0; i < p4.length; i++)
            for (int j = 0; j < p4[0].length; j++) {
                if (p4[i][j].contains(p)) {
                    return new Point(i, j);
                }
            }
        return null;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    Point index = null;
    boolean msp = false;

    public void mousePressed(MouseEvent e) {
        index = getIndex(e.getX(), e.getY());
        if (index == null) {
            return;
        }
        msp = true;
        p4[index.x][index.y].invert();
    }

    public void mouseDragged(MouseEvent e) {
        if (index == null)
            return;
        int x = index.x, y = index.y;
        Point newP = new Point(e.getX(), e.getY());
        p4[x][y].setCenter(newP);
        Dimension d = p4[x][y].getPreferredSize();
        int xg = d.width / 2,yg = d.height / 2;
        p4[x][y].setLocation(newP.x - xg, newP.y - yg);
        repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (index == null)
            return;
        p4[index.x][index.y].invert();
        msp = false;
        index = null;
    }
}