package ip.hak;

import java.awt.*;
import java.io.*;
import java.util.Vector;

public class CopyDir extends ip.gui.frames.ClosableFrame {
    String sd = null;// Source Directory
    String dd = null;// Destination Directory
    String ifiles[];

    public CopyDir(String title) {
        super(title);
        init();
    }

    public static void main(String args[]) {
        CopyDir cd = new CopyDir("Copy Directory Program");
    }

    public void init() {
        // get source & destination directory
        // to select the directory you have to select any file
        // directory
        sd = getDir("Select Source Directory");
        dd = getDir("Select Destination Directory");

        /*
        // test only
        sd="D:\\TEST\\TEMP1";
        dd="D:\\TEST\\TEMP2";
        */

        if (sd == null || dd == null)
            return;

        ifiles = getInputFiles(sd);
        if (ifiles == null)
            return;
        InputDialog id = new InputDialog(this, "", true, ifiles, sd, dd);
        String iv[] = id.getInput();
        if (iv == null)
            changeString(null, null, null, null);
        else
            changeString(iv[0], iv[1], iv[2], iv[3]);

    }

    int counter = 0;

    public void changeString(String inputName, String outputName, String searchString, String replaceString) {
        for (int i = 0; i < ifiles.length; i++) {
            if (inputName == null || !inputName.equals(ifiles[i]))
                copyFile(sd + ifiles[i], dd + ifiles[i]);
            else
                copyFile(sd + inputName, dd + outputName, searchString, replaceString);
        }

        ErrorDialog ed = new ErrorDialog(this, "Result summery",
                "Total " + counter + " string(s) replaced");
    }

    public void copyFile(String s, String d) {
        String line = null;
        try {
            FileReader fr = new FileReader(s);
            FileWriter fw = new FileWriter(d);
            BufferedReader br = new BufferedReader(fr);

            while ((line = br.readLine()) != null)
                fw.write(line + "\n");
            br.close();
            fw.close();
            fr.close();

        } catch (IOException e) {
            System.out.println(e);
        }
    }


    public void copyFile(String s, String d, String ss, String rs) {
        String line = null;
        try {
            FileReader fr = new FileReader(s);
            FileWriter fw = new FileWriter(d);
            BufferedReader br = new BufferedReader(fr);

            while ((line = br.readLine()) != null) {
                line = replaceString(ss, rs, line);
                fw.write(line + "\n");
            }
            br.close();
            fw.close();
            fr.close();

        } catch (IOException e) {
            System.out.println(e);
        }
    }

    public String replaceString(String ss, String rs, String line) {
        int lineSize = line.length();
        int ssSize = ss.length();

        for (int i = 0; i < (lineSize - ssSize); i++) {
            if (line.startsWith(ss, i)) {
                String part1 = line.substring(0, i);
                String part2 = line.substring(i + ssSize);
                counter++;
                return part1 + rs + part2;
            }
        }

        return line;
    }


    public String[] getInputFiles(String st) {
        File f = new File(st);
        String s1[] = f.list();

        if (s1 == null)
            return null;
        Vector v = new Vector();
        for (int i = 0; i < s1.length; i++) {
            f = new File(st, s1[i]);
            if (f.isFile())
                v.addElement(s1[i]);
        }

        String temp[] = new String[v.size()];
        for (int i = 0; i < temp.length; i++)
            temp[i] = (String) v.elementAt(i);

        return temp;
    }

    public String getDir(String title) {
        FileDialog fd = new FileDialog(this, title);
        fd.setVisible(true);
        String fn = fd.getFile();

        if (fn == null)
            return null;

        return fd.getDirectory();
    }
}
