package ip.gui.frames;


import futils.Futil;
import futils.StreamSniffer;
import utils.StopWatch;
import utils.UByte;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.io.*;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import j2d.ImageUtils;

public class OpenFrame extends SaveFrame {
    private boolean fileIsPPM = false;

    MenuItem openImage_mi = addMenuItem(getOpenMenu(), "[o]pen image...");
    MenuItem openPPM_mi = addMenuItem(getOpenMenu(), "open ppm...");
    MenuItem sniff_mi = addMenuItem(getOpenMenu(), "sniff...");
    MenuItem getAsShortgz_mi = addMenuItem(getOpenMenu(),
            "[z]openAsShortgz");
    MenuItem getShortImageZip_mi =
            addMenuItem(getOpenMenu(),
                    "getShortImageZip");

    public void actionPerformed(ActionEvent e) {

        if (match(e, getShortImageZip_mi)) {
            getShortImageZip();
            return;
        }

        if (match(e, getAsShortgz_mi)) {
            getAsShortgz();
            return;
        }
        if (match(e, openImage_mi)) {
            openImage();
            return;
        }
        if (match(e, sniff_mi)) {
            System.out.println("sniffer!");
            ImageUtils.openAndSniffFile();
            return;
        }
        if (match(e, openPPM_mi)) {
            openPPM();
            return;
        }
        super.actionPerformed(e);

    }

    public OpenFrame(String title) {
        super(title);
    }

    public void getAsShortgz() {
        String fn = Futil.getReadFileName();
        if (fn == null) return;
        StopWatch t = new StopWatch();
        t.start();
        try {
            FileInputStream fis = new FileInputStream(fn);
            GZIPInputStream gis = new GZIPInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(gis);
            short[][] r = (short[][]) ois.readObject();
            shortImageBean.setR(r);
            setG((short[][]) ois.readObject());
            setB((short[][]) ois.readObject());
            ois.close();

        } catch (Exception e) {
            System.out.println("Open getAsShortgz Exception:" + e);
        }
        t.stop();
        t.print(" getAsShortgz in ");
        setImageWidth(shortImageBean.getR().length);
        setImageHeight(shortImageBean.getR()[0].length);
        setSize(getImageWidth(), getImageHeight());

        short2Image();
    }

    public void openImage() {
        String fn = Futil.getReadFileName();
        if (fn == null) return;
        File f = new File(fn);
        if (!f.exists()) return;
        setFileName(fn);
        InputStream is = null;
        try {
            is = new FileInputStream(fn);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

        StreamSniffer ss = new StreamSniffer(is);
        int id = ss.classifyStream();
        switch (id) {
            case StreamSniffer.PPM:
                setFileName(fn);
                openPPM(fn);
                break;
            case StreamSniffer.PPM_RAWBITS:
                setFileName(fn);
                openPPM(fn);
                break;
            case StreamSniffer.GIF87a:
                openGif(fn);
                break;
            case StreamSniffer.GIF89a:
                openGif(fn);
                break;
            case StreamSniffer.JPEG:
                setImageResize(
                        Toolkit.getDefaultToolkit().getImage(
                                fn));
                setFileName(fn);

                break;
            case StreamSniffer.GZIP:
                openPPMgz(fn);
                break;
            case StreamSniffer.ZIP_ARCHIVE:
                getShortImageZip(fn);
                break;
            default:
                {
                    System.out.println("Can not open " + ss + " as image");
                }

        }
    }


    public void getShortImageZip() {
        String fn = Futil.getReadFileName();
        if (fn == null) return;
        getShortImageZip(fn);
    }

    public void getShortImageZip(String fn) {
        StopWatch t = new StopWatch();
        t.start();
        try {
            FileInputStream fis = new FileInputStream(fn);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze;
            ze = zis.getNextEntry();
            ObjectInputStream ois =
                    new ObjectInputStream(zis);
            short[][] r = (short[][])
                    ois.readObject();
            shortImageBean.setR(r);
            setG(shortImageBean.getR());
            setB(shortImageBean.getR());
            setImageWidth(shortImageBean.getR().length);
            setImageHeight(shortImageBean.getR()[0].length);
            setSize(getImageWidth(), getImageHeight());
            short2Image();
            ze = zis.getNextEntry();
            setG((short[][])
                    ois.readObject());
            ze = zis.getNextEntry();
            short2Image();
            setB((short[][])
                    ois.readObject());
            zis.close();

        } catch (Exception e) {
            System.out.println("Open getShortImageZip:" + e);
        }
        t.stop();
        t.print(" getShortObjectZip in ");
        short2Image();
    }

    public void getShortImageZip2(String fn) {
        StopWatch t = new StopWatch();
        t.start();
        try {
            FileInputStream fis = new FileInputStream(fn);
            ZipInputStream zis = new ZipInputStream(fis);
            DataInputStream dis = new DataInputStream(zis);
            ZipEntry ze;
            ze = zis.getNextEntry();
            readHeader(dis);
            readArray(shortImageBean.getR(), dis);
            readArray(shortImageBean.getG(), dis);
            readArray(shortImageBean.getB(), dis);
            zis.close();

        } catch (Exception e) {
            System.out.println("Open getShortImageZip:" + e);
        }
        t.stop();
        t.print(" getShortImageZip in ");
        short2Image();
    }

    public void readArray(short a[][], DataInputStream dis)
            throws IOException {
        for (int x = 0; x < getImageWidth(); x++)
            for (int y = 0; y < getImageHeight(); y++)
                a[x][y] = dis.readShort();
    }

    public void readHeader(DataInputStream dis)
            throws IOException {
        int width1 = dis.readInt();
        setImageWidth(width1);
        int height1 = dis.read();
        setImageHeight(height1);
    }

    public static void main(String args[]) {
        OpenFrame f = new OpenFrame("OpenFrame");
        f.show();
    }

    public void openPPMgz(String fn) {
        setFileName(fn);
        StopWatch t = new StopWatch();
        try {
            t.start();
            readShortsGz(fn);
            setImageWidth(shortImageBean.getR().length);
            setImageHeight(shortImageBean.getR()[0].length);
            fileIsPPM = true;
            short2Image();
            t.print("Time to read and display the ppm");
        } catch (Exception e) {
            System.out.println("Read PPM Exception:" + e);
        }

    }

    public void openPPM(String fn) {
        StopWatch t = new StopWatch();
        try {
            t.start();
            readShorts(fn);
            setSize(getImageWidth(), getImageHeight());
            fileIsPPM = true;
            short2Image();
            t.print("Time to read and display the ppm");
        } catch (Exception e) {
            System.out.println("Read PPM Exception:" + e);
        }
        repaint();

    }

    private void readShorts(String fn) {
        StopWatch t = new StopWatch();
        t.start();
        InputStream in = null;
        try {
            in = new FileInputStream(fn);
        } catch (Exception e) {
            e.printStackTrace();
        }
        getShortImage(in);
        t.print("End ReadShorts");
    }

    private void readShortsGz(String fn) {
        StopWatch t = new StopWatch();
        t.start();
        GZIPInputStream in = null;

        try {
            in = new GZIPInputStream(
                    new FileInputStream(fn));
        } catch (Exception e) {
            e.printStackTrace();
        }
        getShortImageGz(in);
        t.print("End ReadShorts");
    }

    private static String getReadName(String prompt) {
        FileDialog fd = new
                FileDialog(new Frame(), prompt);
        fd.setVisible(true);
        fd.setVisible(false);
        String fn = fd.getFile();
        if (fd.getFile() == null) return null; //usr canceled
        return fn;
    }


    public void getShortImage(InputStream in) {
        try {
            Dimension d = ImageUtils.readPpmImageHeader(in);
        } catch (Exception e) {
            e.printStackTrace();
        }
        short[][] r = new short[getImageWidth()][getImageHeight()];
        shortImageBean.setR(r);
        setG(new short[getImageWidth()][getImageHeight()]);
        setB(new short[getImageWidth()][getImageHeight()]);
        byte buf[] = new byte[getImageWidth() * getImageHeight() * 3];
        int offset = 0;
        int count = buf.length;
        int n = 0;

        try {
            n = in.read(buf, offset, count);
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {

            int j = 0;
            for (int col = 0; col < getImageHeight(); col++)
                for (int row = 0; row < getImageWidth(); row++) {
                    shortImageBean.getR()[row][col] = UByte.us(buf[j++]);
                    shortImageBean.getG()[row][col] = UByte.us(buf[j++]);
                    shortImageBean.getB()[row][col] = UByte.us(buf[j++]);
                }
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    private void getShortImageGz(GZIPInputStream in) {

        try {
            ImageUtils.readPpmImageHeader(in);
        } catch (Exception e) {
            e.printStackTrace();
        }
        short[][] r = new short[getImageWidth()][getImageHeight()];
        shortImageBean.setR(r);
        setG(new short[getImageWidth()][getImageHeight()]);
        setB(new short[getImageWidth()][getImageHeight()]);
        byte buf[] = new byte[getImageWidth() * getImageHeight() * 3];
        int len = 0;
        byte bufgz[] = new byte[1024];

        int n = 0;
        try {
            while ((len = in.read(bufgz)) > 0) {
                System.arraycopy(bufgz, 0, buf, n, len);
                n = n + len;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        try {

            int j = 0;
            for (int col = 0; col < getImageHeight(); col++)
                for (int row = 0; row < getImageWidth(); row++) {
                    shortImageBean.getR()[row][col] = UByte.us(buf[j++]);
                    shortImageBean.getG()[row][col] = UByte.us(buf[j++]);
                    shortImageBean.getB()[row][col] = UByte.us(buf[j++]);
                }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public void openPPM() {
        String fn = Futil.getReadFileName();
        if (fn == null) return;
        File f = new File(fn);
        if (!f.exists()) return;
        setFileName(fn);
        openPPM(fn);
    }

}

