package ip.gui.frames;

import ip.gui.MorphUtils;
import j2d.ShortImageBean;
import math.Mat2;

import java.awt.*;
import java.awt.event.ActionEvent;

public class MorphFrame extends EdgeFrame {


    private Menu morphMenu = getMenu("Morph");
    private Menu morphEdgeMenu = getMenu("Edge");
    private Menu dilateMenu = getMenu("Dilate");
    private Menu erodeMenu = getMenu("Erode");
    private Menu openMorphMenu = getMenu("Open");
    private Menu closeMorphMenu = getMenu("Close");
    private Menu insideContourMenu = getMenu("Inside Contour");
    private Menu outsideContourMenu = getMenu("Outside Contour");
    private Menu middleContourMenu = getMenu("Middle Contour");
    private Menu serraMenu = getMenu("Serra Transform (experimental)");
    private Menu morphColorMenu = getMenu("Color (experimental)");

    private MenuItem dilateh_mi = addMenuItem(dilateMenu, "h");
    private MenuItem dilatev_mi = addMenuItem(dilateMenu, "v");
    private MenuItem dilateSquare_mi = addMenuItem(dilateMenu, "square");
    private MenuItem dilateCross_mi = addMenuItem(dilateMenu, "cross");

    private MenuItem erodeh_mi = addMenuItem(erodeMenu, "h");
    private MenuItem erodeh5_mi = addMenuItem(erodeMenu, "hx5");
    private MenuItem erodev_mi = addMenuItem(erodeMenu, "v");
    private MenuItem erodeSquare_mi = addMenuItem(erodeMenu, "square");
    private MenuItem erodeCross_mi = addMenuItem(erodeMenu, "cross");

    private MenuItem openh_mi = addMenuItem(openMorphMenu, "h");
    private MenuItem openv_mi = addMenuItem(openMorphMenu, "v");
    private MenuItem openSquare_mi = addMenuItem(openMorphMenu, "square");
    private MenuItem openCross_mi = addMenuItem(openMorphMenu, "cross");

    private MenuItem closeh_mi = addMenuItem(closeMorphMenu, "h");
    private MenuItem closev_mi = addMenuItem(closeMorphMenu, "v");
    private MenuItem closeSquare_mi = addMenuItem(closeMorphMenu, "square");
    private MenuItem closeCross_mi = addMenuItem(closeMorphMenu, "cross");

    private MenuItem insideContourh_mi = addMenuItem(insideContourMenu, "h");
    private MenuItem insideContourv_mi = addMenuItem(insideContourMenu, "v");
    private MenuItem insideContourSquare_mi = addMenuItem(insideContourMenu, "square");
    private MenuItem insideContourCross_mi = addMenuItem(insideContourMenu, "cross");

    private MenuItem outsideContourh_mi = addMenuItem(outsideContourMenu, "h");
    private MenuItem outsideContourv_mi = addMenuItem(outsideContourMenu, "v");
    private MenuItem outsideContourSquare_mi = addMenuItem(outsideContourMenu, "square");
    private MenuItem outsideContourCross_mi =
            addMenuItem(outsideContourMenu, "[x]cross");

    private MenuItem middleContourh_mi = addMenuItem(middleContourMenu, "h");
    private MenuItem middleContourv_mi = addMenuItem(middleContourMenu, "v");
    private MenuItem middleContourSquare_mi = addMenuItem(middleContourMenu, "square");
    private MenuItem middleContourCross_mi = addMenuItem(middleContourMenu, "cross");

    private MenuItem serrah_mi = addMenuItem(serraMenu, "h");
    private MenuItem serrav_mi = addMenuItem(serraMenu, "v");
    private MenuItem serraSquare_mi = addMenuItem(serraMenu, "square");
    private MenuItem serraCross_mi = addMenuItem(serraMenu, "cross");

    private MenuItem skeleton_mi = addMenuItem(morphEdgeMenu, "[s]keleton");
    private MenuItem thin_mi = addMenuItem(morphEdgeMenu, "[t]hin");


    private MenuItem hatMorph_mi = addMenuItem(morphEdgeMenu, "hat Morph");

    private MenuItem colorDilateErode_mi = addMenuItem(morphColorMenu, "[E-c]olor Dilate-Erode");
    private MenuItem colorDilate_mi = addMenuItem(morphColorMenu, "[E-d]color Dilate");
    private MenuItem colorErode_mi = addMenuItem(morphColorMenu, "[E-e]color Erode");
    private MenuItem colorOpen_mi = addMenuItem(morphColorMenu, "color open");
    private MenuItem colorClose_mi = addMenuItem(morphColorMenu, "color close");
    private MenuItem colorPyramid_mi = addMenuItem(morphColorMenu, "[p]yramid");

    public void actionPerformed(ActionEvent e) {
        if (match(e, thin_mi)) {
            thin();
            return;
        }

        if (match(e, colorPyramid_mi)) {
            colorPyramid(MorphUtils.kSquare);
            return;
        }
        if (match(e, colorOpen_mi)) {
            colorOpen(MorphUtils.kSquare);
            return;
        }
        if (match(e, colorClose_mi)) {
            colorClose(MorphUtils.kSquare);
            return;
        }
        if (match(e, serraSquare_mi)) {
            serra(MorphUtils.kSquare);
            return;
        }

        if (match(e, serrah_mi)) {
            serra(MorphUtils.kh);
            return;
        }

        if (match(e, serrav_mi)) {
            serra(MorphUtils.kv);
            return;
        }

        if (match(e, serraCross_mi)) {
            serra(MorphUtils.kCross);
            return;
        }

        if (match(e, colorErode_mi)) {
            colorErode(MorphUtils.kSquare);
            return;
        }
        if (match(e, colorDilate_mi)) {
            colorDilate(MorphUtils.kSquare);
            return;
        }
        if (match(e, colorDilateErode_mi)) {
            colorDilateErode(MorphUtils.kSquare);
            return;
        }
        if (match(e, skeleton_mi)) {
            skeleton();
            return;
        }
        if (match(e, hatMorph_mi)) {
            hat13v2();
            thresh();
            insideContour(MorphUtils.kh);
            return;
        }

        if (match(e, middleContourh_mi)) {
            middleContour(MorphUtils.kh);
            return;
        }
        if (match(e, middleContourv_mi)) {
            middleContour(MorphUtils.kv);
            return;
        }
        if (match(e, middleContourSquare_mi)) {
            middleContour(MorphUtils.kSquare);
            return;
        }
        if (match(e, middleContourCross_mi)) {
            middleContour(MorphUtils.kCross);
            return;
        }
        if (match(e, insideContourh_mi)) {
            insideContour(MorphUtils.kh);
            return;
        }
        if (match(e, insideContourv_mi)) {
            insideContour(MorphUtils.kv);
            return;
        }
        if (match(e, insideContourSquare_mi)) {
            insideContour(MorphUtils.kSquare);
            return;
        }
        if (match(e, insideContourCross_mi)) {
            insideContour(MorphUtils.kCross);
            return;
        }

        if (match(e, outsideContourh_mi)) {
            outsideContour(MorphUtils.kh);
            return;
        }
        if (match(e, outsideContourv_mi)) {
            outsideContour(MorphUtils.kv);
            return;
        }
        if (match(e, outsideContourSquare_mi)) {
            outsideContour(MorphUtils.kSquare);
            return;
        }
        if (match(e, outsideContourCross_mi)) {
            outsideContour(MorphUtils.kCross);
            return;
        }
        if (match(e, openh_mi)) {
            open(MorphUtils.kh);
            return;
        }
        if (match(e, openv_mi)) {
            open(MorphUtils.kv);
            return;
        }
        if (match(e, openSquare_mi)) {
            open(MorphUtils.kSquare);
            return;
        }
        if (match(e, openCross_mi)) {
            open(MorphUtils.kCross);
            return;
        }
        if (match(e, closeh_mi)) {
            close(MorphUtils.kh);
            return;
        }
        if (match(e, closev_mi)) {
            close(MorphUtils.kv);
            return;
        }
        if (match(e, closeSquare_mi)) {
            close(MorphUtils.kSquare);
            return;
        }
        if (match(e, closeCross_mi)) {
            close(MorphUtils.kCross);
            return;
        }
        if (match(e, erodeCross_mi)) {
            erode(MorphUtils.kCross);
            return;
        }
        if (match(e, erodeSquare_mi)) {
            erode(MorphUtils.kSquare);
            return;
        }

        if (match(e, erodeh5_mi)) {
            erode(MorphUtils.kh);
            erode(MorphUtils.kh);
            erode(MorphUtils.kh);
            erode(MorphUtils.kh);
            erode(MorphUtils.kh);
            return;
        }
        if (match(e, erodeh_mi)) {
            erode(MorphUtils.kh);
            return;
        }
        if (match(e, erodev_mi)) {
            erode(MorphUtils.kv);
            return;
        }
        if (match(e, dilateCross_mi)) {
            dilate(MorphUtils.kCross);
            return;
        }
        if (match(e, dilateSquare_mi)) {
            dilate(MorphUtils.kSquare);
            return;
        }
        if (match(e, dilateh_mi)) {
            dilate(MorphUtils.kh);
            return;
        }
        if (match(e, dilatev_mi)) {
            dilate(MorphUtils.kv);
            return;
        }
        super.actionPerformed(e);

    }

    public void colorPyramid(float k[][]) {
        short[][] r = MorphUtils.dilategs(MorphUtils.erodegs(shortImageBean.getR(), k), k);
        shortImageBean.setR(r);
        setG(MorphUtils.dilategs(MorphUtils.erodegs(shortImageBean.getG(), k), k));
        setB(MorphUtils.dilategs(MorphUtils.erodegs(shortImageBean.getB(), k), k));
        short[][] r1 = MorphUtils.erodegs(MorphUtils.dilategs(shortImageBean.getR(), k), k);
        shortImageBean.setR(r1);
        setG(MorphUtils.erodegs(MorphUtils.dilategs(shortImageBean.getG(), k), k));
        setB(MorphUtils.erodegs(MorphUtils.dilategs(shortImageBean.getB(), k), k));
        resample(2);
        short2Image();
    }

    public void resample2(int ratio) {
        child = new MorphFrame("MorphFrame");
        ImageFrameInterface frame = child;
        int width1 = getImageWidth() / 2;
        frame.setImageWidth(width1);
        ImageFrameInterface frame1 = child;
        int height1 = getImageHeight() / 2;
        frame1.setImageHeight(height1);
        short[][] r = Mat2.resample(shortImageBean.getR(), 2);
        shortImageBean.setR(r);
        child.setG(Mat2.resample(shortImageBean.getG(), 2));
        child.setB(Mat2.resample(shortImageBean.getB(), 2));
    }

    public void resample(int ratio) {
        int width1 = getImageWidth() / 2;
        setImageWidth(width1);
        int height1 = getImageHeight() / 2;
        setImageHeight(height1);
        short[][] r = Mat2.resample(shortImageBean.getR(), 2);
        shortImageBean.setR(r);
        setG(Mat2.resample(shortImageBean.getG(), 2));
        setB(Mat2.resample(shortImageBean.getB(), 2));
    }

    public void colorOpen(float k[][]) {
        short[][] r = MorphUtils.dilategs(MorphUtils.erodegs(shortImageBean.getR(), k), k);
        shortImageBean.setR(r);
        setG(MorphUtils.dilategs(MorphUtils.erodegs(shortImageBean.getG(), k), k));
        setB(MorphUtils.dilategs(MorphUtils.erodegs(shortImageBean.getB(), k), k));
        short2Image();
    }

    public void colorClose(float k[][]) {
        short[][] r = MorphUtils.erodegs(MorphUtils.dilategs(shortImageBean.getR(), k), k);
        shortImageBean.setR(r);
        setG(MorphUtils.erodegs(MorphUtils.dilategs(shortImageBean.getG(), k), k));
        setB(MorphUtils.erodegs(MorphUtils.dilategs(shortImageBean.getB(), k), k));
        short2Image();
    }

    public void open(float k[][]) {
        short[][] r = MorphUtils.dilate(MorphUtils.erode(shortImageBean.getR(), k), k);
        shortImageBean.setR(r);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public void close(float k[][]) {
        short[][] r = MorphUtils.erode(MorphUtils.dilate(shortImageBean.getR(), k), k);
        shortImageBean.setR(r);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public void serra(float k[][]) {
        short[][] r = MorphUtils.erode(shortImageBean.getR(), k);
        shortImageBean.setR(r);
        setG(MorphUtils.erode(complement(shortImageBean.getG()), MorphUtils.kSquare));
        short[][] r1 = intersect(shortImageBean.getR(), shortImageBean.getG());
        shortImageBean.setR(r1);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public short[][] intersect(short a[][], short b[][]) {
        int w = a.length;
        int h = a[0].length;
        short c[][] = new short[w][h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++)
                if (a[x][y] == b[x][y])
                    c[x][y] = a[x][y];
        return c;
    }

    public short[][] complement(short s[][]) {
        int w = s.length;
        int h = s[0].length;
        short sComp[][] = new short[w][h];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++)
                sComp[x][y] = (short) (255 - s[x][y]);
        return sComp;
    }

    public static void main(String args[]) {
        MorphFrame ef = new MorphFrame("MorphFrame");
        ef.show();
    }


    public void dilate(float k[][]) {
        short[][] r = MorphUtils.dilate(shortImageBean.getG(), k);
        shortImageBean.setR(r);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public void erode(float k[][]) {
        short[][] r = MorphUtils.erode(shortImageBean.getG(), k);
        shortImageBean.setR(r);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public void colorDilateErode(float k[][]) {
        for (int i = 0; i < 5; i++)
            colorDilate(k);
        for (int i = 0; i < 5; i++)
            colorErode(k);
    }

    public void colorDilate(float k[][]) {
        short[][] r =
                MorphUtils.dilategs(
                        shortImageBean.getR(),
                        k);
        shortImageBean.setR(r);
        setG(MorphUtils.dilategs(
                shortImageBean.getG(), k));
        setB(MorphUtils.dilategs(
                shortImageBean.getB(), k));
        short2Image();
    }

    public void colorErode(float k[][]) {
        short[][] r = MorphUtils.erodegs(
                shortImageBean.getR(), k);
        shortImageBean.setR(r);
        setG(MorphUtils.erodegs(
                shortImageBean.getG(), k));
        setB(MorphUtils.erodegs(
                shortImageBean.getB(), k));
        short2Image();
    }


    public void insideContour(float k[][]) {
        short[][] r = Mat2.subtract(shortImageBean.getG(), MorphUtils.erode(shortImageBean.getG(), k));
        shortImageBean.setR(r);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public void outsideContour(float k[][]) {
        short[][] r = Mat2.subtract(MorphUtils.dilate(shortImageBean.getG(), k), shortImageBean.getG());
        shortImageBean.setR(r);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public void middleContour(float k[][]) {
        short[][] r = Mat2.subtract(
                MorphUtils.dilate(shortImageBean.getG(), k),
                MorphUtils.erode(shortImageBean.getG(), k));
        shortImageBean.setR(r);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public void thin() {
        skeletonRedPassSuen(true);
        skeletonRedPassSuen(false);
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }

    public void skeleton() {
        while (
                skeletonRedPassSuen(true) &&
                skeletonRedPassSuen(false)) {
        }
        shortImageBean.copyRedToGreenAndBlue();
        short2Image();
    }


    // p7 p0 p1
    // p6 --- p2
    // p5 p4 p3
    public boolean skeletonRedPassSuen(
            boolean firstPass) {
        ShortImageBean sib = shortImageBean;
        short c = MorphUtils.redPassSuen(sib, firstPass);
        //System.out.println("c="+c);
        if (c == 0) return false;
        deleteFlagedPoints();
        return true;
    }

    public void deleteFlagedPoints() {
        for (int x = 1; x < getImageWidth() - 1; x++)
            for (int y = 1; y < getImageHeight() - 1; y++)
                if (shortImageBean.getG()[x][y] != 0)
                    shortImageBean.getR()[x][y] = 0;
    }


    MorphFrame(String title) {
        super(title);
        morphMenu.add(erodeMenu);
        morphMenu.add(dilateMenu);
        morphMenu.add(openMorphMenu);
        morphMenu.add(closeMorphMenu);
        morphMenu.add(insideContourMenu);
        morphMenu.add(middleContourMenu);
        morphMenu.add(outsideContourMenu);
        morphMenu.add(morphEdgeMenu);
        morphMenu.add(morphColorMenu);
        morphMenu.add(serraMenu);
        SpatialFilterMenu.add(morphMenu);

    }


}