package ip.gui.frames;

import futils.Futil;
import j2d.ImageUtils;
import graphics.NumImage;
import gui.Clipper;
import gui.ImageBean;
import gui.ImageBeanInterface;
import ip.gui.CommandLineInterpreter;
import j2d.ShortImageBean;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.image.ColorModel;
import java.io.File;

public class ImageFrame
        extends ShortCutFrame
        implements ImageFrameInterface {


    private ImageBeanInterface ib = new ImageBean();
    public ShortImageBean shortImageBean =
            new ShortImageBean();


// No, you can't use bytes, cause
// Java bytes are signed. Yeah, that bites!

    private MenuBar menuBar = new MenuBar();
    private Menu fileMenu = new Menu("File");

    private Menu openMenu = new Menu("Open");
    private MenuItem openGif_mi =
            addMenuItem(getOpenMenu(), "[g]if...");
    private MenuItem default_mi =
            addMenuItem(getOpenMenu(), "[d]efault image");
    private MenuItem revert_mi =
            addMenuItem(getOpenMenu(), "[r]evert");
    private MenuItem fitScreen_mi =
            addMenuItem(getOpenMenu(), "fitScreen");
    CommandLineInterpreter
            cli = new CommandLineInterpreter(this);
    InfoFrame infoFrame
            = new InfoFrame(cli);
    private String dir = null;

    public void actionPerformed(ActionEvent e) {

        if (match(e, fitScreen_mi)) {
            ImageUtils.fitScreen(this);
            return;
        }
        if (match(e, openGif_mi)) {
            openGif();
            return;
        }
        if (match(e, default_mi)) {
            grabNumImage();
            return;
        }
        if (match(e, revert_mi)) {
            revert();
            return;
        }
    }

    public void setG(short r[][]) {
        shortImageBean.setG(r);
    }

    public void setB(short r[][]) {
        shortImageBean.setB(r);
    }

    public ImageFrame(String title) {
        super(title);
        initialize();
    }

    public ImageBeanInterface getImageBean() {
        return ib;
    }


    private void initialize() {
        initMenu();
        grabNumImage();

        show();
        setSize(getImageWidth(), getImageHeight());
        repaint();
    }


    public void grabNumImage() {
        ib.setFromFile(false);
        shortImageBean.setR(NumImage.getGray());
        shortImageBean.setG(NumImage.getGray());
        shortImageBean.setB(NumImage.getGray());
        getClipper().setClipped(false);
        ib.setImage(shortImageBean);
        Rectangle r = getBounds();
        repaint(0, 0, r.width, r.height);
    }

    private void initMenu() {
        getFileMenu().add(getOpenMenu());
        menuBar.add(getFileMenu());
        setMenuBar(menuBar);
    }

    public void setImageResize(Image i) {
        ib.setImage(i);
        setSize(ib.getImageWidth(), ib.getImageHeight());
        setVisible(true);
        repaint();
        image2Short();
    }

    public void setImage(Image i) {
        ib.setImage(i);
        image2Short();
    }

    public void setImageNoShort(Image img) {
        setImage(img);
        ImageUtils.waitForImage(this, img);
        setImageWidth(img.getWidth(this));
        setImageHeight(img.getHeight(this));
    }

    public Image getImage() {
        ImageUtils.waitForImage(this, ib.getImage());
        return ib.getImage();
    }

    public String getFileName() {
        return ib.getFile() + "";
    }

    public Clipper getClipper() {
        return shortImageBean.getClipper();
    }


    /**
     short2Image - turn 3 short arrays, r, g and b into an image.
     */
    public void short2Image() {
        Clipper clipper = getClipper();
        clipper.setClipped(false);
        ib.setImage(shortImageBean);
        Rectangle r = getBounds();
        repaint(0, 0, r.width, r.height);
    }

    public void pels2Image(int pels[]) {
        setImageWidth(shortImageBean.getR().length);
        setImageHeight(shortImageBean.getR()[0].length);
        Image i = ImageUtils.getImage(pels, getImageWidth(), getImageHeight());
        setImageNoShort(i);
        Rectangle r = getBounds();
        repaint(0, 0, r.width, r.height);
    }


    /**
     image2Short - takes the private Image instance and
     makes 3 short arrays, r, g and b.
     */
    public void image2Short() {
        if (getImage() == null) return;
        if (getImageWidth() < 0) return;
        if (getImageHeight() < 0) return;
        Image img = ib.getImage();
        ImageUtils.waitForImage(this, img);
        shortImageBean.setImage(img);
    }


    public void openGif() {
        String fn =
                Futil.getReadFileName();
        if (fn == null) return;
        openGif(fn);
    }

    public void setFtpFileName(String _fn) {
        setFileName(_fn);
        setImageComesFromFile(false);
    }

    public void setFileName(String _fn) {
        File f = new File(_fn);
        if (!f.exists()) return;
        ib.setFile(f);
        infoFrame.println(
                "File:" + _fn +
                "\nis " + f.length() + " bytes long");
        setImageComesFromFile(true);

    }

    public void openGif(String fn) {
        File f = new File(fn);
        if (!f.exists()) {
            grabNumImage();
            return;
        }

        setFileName(fn);
        ib.setImage(
                Toolkit.getDefaultToolkit().getImage(
                        getFileName()));
        image2Short();
        ImageUtils.waitForImage(this, ib.getImage());
        setImageResize(ib.getImage());
        setImageComesFromFile(true);
    }

    public void revert() {
        if (isImageComesFromFile()) {
            getImageFromFile();
        } else
            grabNumImage();

    }

    private void getImageFromFile() {
        if (getFileName() == null)
            openGif();
        else {
            setImage(Toolkit.getDefaultToolkit().getImage(getFileName()));
            setImageResize(getImage());
        }
    }

    public void revertNoResize() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (isImageComesFromFile()) {
            if (getFileName() == null)
                openGif();
            else {
                setImage(tk.getImage(getFileName()));
                setImage(getImage());
            }
        } else
            grabNumImage();

    }

    // Takes a packed RGB model and makes
    // the short arrays
    /* No usages found!
    public void int2Short(int pels[]) {
        int w = ib.getImageWidth();
        int h = ib.getImageHeight();
        ColorModel cm = ib.getColorModel();
        sib.setR(new short[w][h]);
        sib.setG(new short[w][h]);
        sib.setB(new short[w][h]);
        int i = 0;
        for (int x = 0; x < w; x++)
            for (int y = 0; y < h; y++) {
                i = x + y * w;
                sib.getB()[x][y] = (short) cm.getBlue(pels[i]);
                sib.getG()[x][y] = (short) cm.getGreen(pels[i]);
                sib.getR()[x][y] = (short) cm.getRed(pels[i]);
            }
    }
    */


    public static void main(String args[]) {
        ImageFrame imgFrm =
                new ImageFrame("Image Frame");
        imgFrm.openGif();
    }

    public void paint(Graphics g) {
        if (getImage() != null) {
            Dimension r = getSize();
            g.drawImage(getImage(), 0, 0, r.width, r.height,
                    this);
        }
    }

    public int getImageWidth() {
        return ib.getImageWidth();
    }

    public void setImageWidth(int imageWidth) {
        ib.setImageWidth(imageWidth);
    }

    public int getImageHeight() {
        return ib.getImageHeight();
    }

    public void setImageHeight(int imageHeight) {
        ib.setImageHeight(imageHeight);
    }

    public boolean isImageComesFromFile() {
        return ib.isFromFile();
    }

    public void setImageComesFromFile(boolean imageComesFromFile) {
        ib.setFromFile(imageComesFromFile);
    }

    public ColorModel getCm() {
        return ib.getColorModel();
    }

    public Menu getFileMenu() {
        return fileMenu;
    }

    public void setFileMenu(Menu fileMenu) {
        this.fileMenu = fileMenu;
    }

    public Menu getOpenMenu() {
        return openMenu;
    }

    public void setOpenMenu(Menu openMenu) {
        this.openMenu = openMenu;
    }

    public String getDir() {
        return dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public ShortImageBean getShortImageBean() {
        return shortImageBean;
    }


}