package ip.gui.frames;

import j2d.ImageUtils;
import ip.gui.applets.NetImageSelectorApplet;
import utils.Print;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.net.URL;

public class GrabFrame extends FilterFrame {

    private SnellWlx sw;

    private NetImageSelectorApplet nis;

    String home =
            "http://www.docjava.com/java/images/";
    String audioHome =
            "http://www.docjava.com/java/au/";
    String liveCam =
            "http://192.107.38.225/mydoc01.jpg";

    Menu grabMenu = getMenu("Grab");
    Menu netMenu = getMenu("ip.net");
    MenuItem cover_mi = addMenuItem(netMenu, "cover");
    MenuItem ublogo_mi = addMenuItem(netMenu, "logo");
    MenuItem author_mi = addMenuItem(netMenu, "the author");
    MenuItem plane_mi = addMenuItem(netMenu, "airplane.JPEG");
    MenuItem baboon_mi = addMenuItem(netMenu, "baboon.JPEG");
    MenuItem lena_mi = addMenuItem(netMenu, "lena.JPEG");
    MenuItem peppers_mi = addMenuItem(netMenu, "peppers.JPEG");
    MenuItem kmap_mi = addMenuItem(netMenu, "kmapAnimation.ip.gif");
    MenuItem computer_mi = addMenuItem(netMenu, "computer.au");
    MenuItem yenrab_mi = addMenuItem(netMenu, "yenrab.au");

    MenuItem live_mi = addMenuItem(netMenu, "liveCam");

    MenuItem testPattern_mi = addMenuItem(grabMenu, "[T]est Patterns");

    MenuItem grabTestPattern_mi = addMenuItem(grabMenu, "[E-G]rab Patterns");

    public void actionPerformed(ActionEvent e) {

        if (match(e, computer_mi)) {
            netSoundSelector(audioHome + "computer.au");
            return;
        }
        if (match(e, yenrab_mi)) {
            netSoundSelector(audioHome + "yenrab.au");
            return;
        }
        if (match(e, live_mi)) {
            netImageSelector(liveCam);
            return;
        }
        if (match(e, plane_mi)) {
            netImageSelector(home + "airplane.JPEG");
            return;
        }
        if (match(e, baboon_mi)) {
            netImageSelector(home + "baboon.JPEG");
            return;
        }
        if (match(e, peppers_mi)) {
            netImageSelector(home + "peppers.JPEG");
            return;
        }
        if (match(e, lena_mi)) {
            netImageSelector(home + "lena.JPEG");
            return;
        }
        if (match(e, kmap_mi)) {
            netImageSelector(home + "kmapAnimation.ip.gif");
            return;
        }

        if (match(e, author_mi)) {
            netImageSelector("http://www.docjava.com/Pub/Documentation/me.ip.gif");
            return;
        }
        if (match(e, cover_mi)) {
            netImageSelector("http://www.docjava.com/book/1558515682.m.ip.gif");
            return;
        }
        if (match(e, ublogo_mi)) {
            netImageSelector("http://www.docjava.com/bgublogo.ip.gif");
            return;
        }
        if (match(e, testPattern_mi)) {
            testPattern();
            return;
        }
        if (match(e, grabTestPattern_mi)) {
            grabTestPattern();
            return;
        }
        super.actionPerformed(e);
    }

    public GrabFrame(String title) {
        super(title);
        grabMenu.add(netMenu);

        getFileMenu().add(grabMenu);
    }

    public void testPattern() {
        sw = new SnellWlx();
        sw.init();
        sw.start();
        sw.setSize(256, 256);
    }

    public void revert() {
        if (urlString == null) {
            super.revert();
            return;
        }
        netImageSelector(urlString);
    }

    public static void netSoundSelector(String st) {
        URL url = null;
        try {
            url = new URL(st);
        } catch (Exception e) {
            e.printStackTrace();
        }
        netSoundSelector(url);
    }

    public static void netSoundSelector(URL url) {
        sound.UlawCodec.play(url);
    }

    public void netImageSelector(String st) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img;
        urlString = st;
        URL url = null;
        Print.println("Loading..." + st);
        try {
            url = new URL(st);
        } catch (Exception e) {
            e.printStackTrace();
        }

        img = tk.getImage(url);
        ImageUtils.waitForImage(this, img);
        if (img == null) {
            Print.println("netload failed");
            return;
        }
        setImage(img);
        setSize(getImageWidth(), getImageHeight());
        repaint();
    }

    String urlString = null;

    public void grab(Container f) {
        setImageWidth(f.getSize().width);
        setImageHeight(f.getSize().height);
        Image backBuffer = createImage(getImageWidth(), getImageHeight());
        Graphics g = backBuffer.getGraphics();
        f.paint(g);
        setImage(backBuffer);
        g = getGraphics();
        g.clearRect(0, 0, getSize().width, getSize().height);
        setSize(getImageWidth(), getImageHeight());
        repaint();
    }

    public void grabTestPattern() {
        if (sw == null) {
            testPattern();
        }
        grab(sw);
    }

    public static void main(String args[]) {
        GrabFrame gf = new GrabFrame("Grab Frame");
        gf.testPattern();
    }
}
