package ip.gui.frames;

import j2d.ImageUtils;
import ip.transforms.Kernels;

import java.awt.*;
import java.awt.event.ActionEvent;

public class FilterFrame extends ImageFrame {

    Menu filterMenu = getMenu("Filter");

    Menu rgbMenu = getMenu("RGBto");
    MenuItem gray_mi =
            addMenuItem(rgbMenu, "[E-g]ray");
    MenuItem blurFast_mi =
            addMenuItem(rgbMenu, "blurFast");

    public void actionPerformed(ActionEvent e) {
        if (match(e, gray_mi)) {
            gray();
            return;
        }
        if (match(e, blurFast_mi)) {
            blurFast();
            return;
        }
        super.actionPerformed(e);
    }

    public void blurFast() {
        convolveFast(Kernels.getHat13());
    }

    public void convolveFast(float k[][]) {
        setImage(ImageUtils.convolution(getImage(), k));
        super.image2Short();
        repaint();
    }

    public void gray() {
        shortImageBean.gray();
        short2Image();
    }

    public FilterFrame(String title) {
        super(title);
        MenuBar menuBar = getMenuBar();
        filterMenu.add(rgbMenu);
        menuBar.add(filterMenu);
        setMenuBar(menuBar);
        //filterMenu.addActionListener(this);
        //rgbMenu.addActionListener(this);
    }

    public static void main(String args[]) {
        FilterFrame imgFrm =
                new FilterFrame("FilterFrame");
    }
}




