//--------------------------------
//File: 		ArrayDialog.java
//Date: 		03/29/99
//Student id: 	0424811
//Student name: Jitendra Shiralkar
//Compiled on: 	JDK 1.2
//--------------------------------
//
//Class implemented: ArrayDialog
//Derived from:      Dialog
//
//Description:
//	The ArrayDialog class accepts string values for the array elements.
//The user is prompted to enter the no. of rows and columns at the system console.
//
package ip.gui.dialog;

import ip.gui.frames.ClosableFrame;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class ArrayDialog extends
        ClosableFrame implements ActionListener {
    private TextField fields[][];
    public Button cancelButton = new Button("Cancel");
    public Button setButton = new Button("Set");
    private int fieldSize;

    private static int colSpace = 5;
    private static int rowSpace = 10;
    private Panel inputPanel = new Panel();

    int noOfRows = 0, noOfCols = 0;


    public ArrayDialog(Frame frame, String title,
                       String defaults[][], int row, int col, int _fieldSize) {

        super(title);

        if (row == 0) {
            RowColLog rcl = new RowColLog();
        } else {
            noOfRows = row;
            noOfCols = col;
        }

        initialize(defaults, noOfRows, noOfCols, _fieldSize);
        pack();
        show();
    }

    private void initialize(String defaults[][], int row, int col, int _fieldSize) {

        fieldSize = _fieldSize;
        fields = new TextField[row][col];

        inputPanel.setLayout(new GridLayout(row + 1, col + 1, colSpace, rowSpace));

        inputPanel.add(new Label("R\\C"));
        for (int i = 0; i < col; i++)
            inputPanel.add(new Label("col " + (i + 1)));

        for (int i = 0; i < row; i++) {
            inputPanel.add(new Label("row " + (i + 1)));


            for (int j = 0; j < col; j++) {
                if (defaults == null)
                    fields[i][j] = new TextField(fieldSize);
                else
                    fields[i][j] = new TextField(defaults[i][j], fieldSize);

                inputPanel.add(fields[i][j]);
            }
        }
        add("Center", inputPanel);
        buttonPanel();
    }


    private void buttonPanel() {
        Panel p2 = new Panel();
        p2.setLayout(new FlowLayout(FlowLayout.CENTER)); //RIGHT));

        p2.add(cancelButton);
        p2.add(setButton);
        cancelButton.addActionListener(this);
        setButton.addActionListener(this);
        add("South", p2);
        pack();
        show();
    }

    public void printUserInput() {
        String userInput[][] = getUserInput();
        for (int i = 0; i < fields.length; i++) {
            for (int j = 0; j < fields[0].length; j++) {
                userInput[i][j] = fields[i][j].getText();
                System.out.print(userInput[i][j] + " ");
            }
            System.out.println();
        }
    }

    public String[][] getUserInput() {
        String userInput[][] = new String[fields.length][fields[0].length];
        for (int i = 0; i < fields.length; i++)
            for (int j = 0; j < fields[0].length; j++)
                userInput[i][j] = fields[i][j].getText();
        return userInput;
    }

    public static void main(String args[]) {
        String title = "Rotation Dialog";
        int fieldSize = 6;
        String defaults[][] = null;

        ArrayDialog xpol = new ArrayDialog(new Frame(), title,
                defaults, 3, 3, fieldSize);
    }

    public void actionPerformed(ActionEvent e) {
        Button b = (Button) e.getSource();
        if (b == cancelButton)
            setVisible(false);
        else
            printUserInput();
    }
//}

    class RowColLog extends Dialog implements ActionListener {
        Button okButton = new Button("OK");
        Button cancelButton = new Button("CANCEL");

        Label rowLabel = new Label("Enter no. of rows:");
        Label colLabel = new Label("Enter no. of columns:");
        TextField rowField = new TextField();
        TextField colField = new TextField();


        public RowColLog() {
            super(new Frame(), "Rows and columns input", true);	//sets the RowColLog modal

            okButton.addActionListener(this);
            cancelButton.addActionListener(this);

            setLayout(new GridLayout(0, 2));
            add(rowLabel);
            add(rowField);
            add(colLabel);
            add(colField);
            add(okButton);
            add(cancelButton);

            pack();
            show();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == okButton) {
                try {
                    noOfRows = Integer.parseInt(rowField.getText());
                    noOfCols = noOfRows = Integer.parseInt(colField.getText());
                    setVisible(false);
                } catch (NumberFormatException ne) {
                    StringBuffer message = new StringBuffer();
                    message.append("Please enter a valid integer at: ");
                    message.append(ne.getMessage());

                    MessageLog m1 = new MessageLog("Input error", message.toString());
                }
//			setVisible(false);
            } else if (e.getSource() == cancelButton) {
                System.exit(1);
            }
        }
    }

    class MessageLog extends Dialog implements ActionListener {
        Button okButton = new Button("OK");
        Panel buttonPanel = new Panel();
        Label messageLabel = new Label();

        public MessageLog(String title, String message) {
            super(new Frame(), title, true);	//sets the MessageLog modal
            okButton.addActionListener(this);
            messageLabel.setText(message);

            setLayout(new GridLayout(0, 1));
            add(messageLabel);
            add(okButton);
            pack();
            show();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == okButton)
                setVisible(false);
        }
    }
}
