package ip.gui;

import java.awt.*;

public class EdgeElement {
    //private static final int OPEN = 1;
    //private static final int CLOSED = 0;
    private boolean open = true;


    private EdgeElement parent = null;
    public Point p1 = new Point(0, 0);
    public Point p2 = new Point(0, 0);

    private int cost = 0;

    public EdgeElement() {
    }

    public EdgeElement(EdgeElement e) {
        p1.x = e.p1.x;
        p1.y = e.p1.y;
        p2.x = e.p2.x;
        p2.y = e.p2.y;
        cost = e.cost;
        e.setOpen(e.isOpen());
    }

    public void setCoordinates(Point _p1, Point _p2) {
        p1.x = _p1.x;
        p1.y = _p1.y;
        p2.x = _p2.x;
        p2.y = _p2.y;
    }

    public void setOpen(boolean _open) {
        open = _open;
    }


    public boolean isOpen() {
        return open;
    }


    public void setParent(EdgeElement _parent) {
        parent = _parent;
    }

    public EdgeElement getParent() {
        return parent;
    }

    public void setCost(int _c) {
        if (parent == null)
            cost = _c;
        else
            cost = _c + parent.getCost();
    }

    public int getPly() {
        if (parent == null)
            return 0;
        return parent.getPly() + 1;
    }


    public int getCost() {
        return cost;
    }

    public Polygon getPath() {
        EdgeElement pos = this;
        Polygon p = new Polygon();
        while (pos != null) {
            p.addPoint(pos.p2.x, pos.p2.y);
            pos = pos.getParent();
        }
        return p;
    }

    public int distance(Point p) {
        return (int) p2.distance(p.x, p.y);

    }
}
