package ip.gabor;

import gui.run.RunSlider;

import javax.swing.*;


public class GaborView {
    GaborParams gp = null;

    GaborView(GaborParams _gp) {
        gp = _gp;
        init();
    }


    public void init() {
        gui.ClosableJFrame cf = new gui.ClosableJFrame();
        cf.setSize(200, 200);
        java.awt.Container c = cf.getContentPane();
        c.setLayout(new java.awt.FlowLayout());
        thetaSlide(c);
        lambdaSlide(c);
        sigmaSlide(c);
        phiSlide(c);
        cf.setVisible(true);
    }

    private void thetaSlide(java.awt.Container c) {
        c.add(new RunSlider(0, 180, gp.getTheta()) {
            public void run() {
                gp.setTheta(Math.PI * getValue() / 180.0);
            }
        });
        c.add(new JLabel("theta"));
    }


    private void lambdaSlide(java.awt.Container c) {
        c.add(new RunSlider(0, 100, gp.getLambda()) {
            public void run() {
                gp.setLambda(getValue());
            }
        });
        c.add(new JLabel("lambda"));
    }

    private void phiSlide(java.awt.Container c) {
        c.add(new RunSlider(-180, 180, gp.getPhi()) {
            public void run() {
                gp.setPhi(Math.PI * getValue() / 180.0);
            }
        });
        c.add(new JLabel("phi"));
    }

    private void sigmaSlide(java.awt.Container c) {
        c.add(new RunSlider(0, 100, gp.getSigma()) {
            public void run() {
                gp.setSigma(getValue());
            }
        });
        c.add(new JLabel("sigma"));
    }

}