package ip.gabor;


import futils.Futil;

import java.awt.*;
import java.io.File;
import java.util.Observable;
import java.util.Observer;

public class GaborPanel extends Panel
        implements Observer {

    private GaborCanvas spaceCanvas = new GaborCanvas();
    //private GaborCanvas fourierCanvas = new GaborCanvas();
    private FilterCanvas originalImage = new FilterCanvas();


    // 24 angles at 15 degee increments
    private GaborCanvas spaceArray[] = new GaborCanvas[18];

    // This is the delta theta for the gabor subband.
    private double angleIncrement = 180.0 / spaceArray.length;

    private int kernelSize = 7;//used to be 7
    private GaborParams gaborParams = new GaborParams();

    public GaborParams getParams() {
        return gaborParams;
    }

    public GaborPanel(Image img) {
        originalImage.setImage(img);
    }

    public GaborPanel() {

    }

    public FilterCanvas[] getFilters() {
        return filters;
    }

    public static Frame getGaborFrame() {
        Frame f = new Frame();
        GaborPanel gaborPanel = new GaborPanel();
        f.setLayout(new BorderLayout());
        f.add(gaborPanel, BorderLayout.CENTER);
        gaborPanel.init();
        f.show();
        f.setSize(200, 200);
        return f;
    }

    public Image getGaborImage() {
        return spaceCanvas.getImage();
    }

    public static void main(String[] args) {
        getGaborFrame();
    }

    public void save() {
        File fn = Futil.getWriteFile("select fn.gz");

        for (int i = 0; i < spaceArray.length; i++) {
            GaborCanvas gc = spaceArray[i];
            String f = fn.getAbsolutePath() + i;
            gc.saveAsJava(new File(f));
        }
    }


    public void init() {
        new GaborView(gaborParams);
        setLayout(new GridLayout(6, 0));

        filters = new FilterCanvas[spaceArray.length];
        for (int i = 0; i < spaceArray.length; i++) {
            spaceArray[i] = new GaborCanvas();
            add(spaceArray[i]);

        }

        gaborParams.addObserver(this);

        for (int i = 0; i < spaceArray.length; i++) {
            filters[i] = new FilterCanvas();
            //filters[i].convolution(originalImage.getImage(), spaceArray[i].getKernel());
            add(filters[i]);

        }
        update(null, null);


    }

    FilterCanvas filters[];

    private Panel create_panel(String string, String string_0_) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(3, 0));
        Label label = new Label(string);
        label.setAlignment(1);
        panel.add(label);

        return panel;
    }


    public void update(Observable o, Object arg) {
        spaceCanvas.ComputeImageArrays(kernelSize, gaborParams.getLambda(),
                gaborParams.getTheta(), gaborParams.getPhi(),
                gaborParams.getGamma_val(), gaborParams.getSigma());
        //fourierCanvas.ComputeImageArrays(kernelSize, gaborParams.getLambda(),
        //        gaborParams.getTheta(), gaborParams.getPhi_val(),
        //        gaborParams.getGamma_val(), gaborParams.getSigma());

        spaceCanvas.drawImage("space");
        //fourierCanvas.drawImage("fourier");

        for (int i = 0; i < spaceArray.length; i++) {
            GaborCanvas gc = spaceArray[i];
            gc.ComputeImageArrays(kernelSize, gaborParams.getLambda(),
                    i * angleIncrement, gaborParams.getPhi(),
                    gaborParams.getGamma_val(), gaborParams.getSigma());
            gc.drawImage("space");
            filters[i].convolution(originalImage.getImage(), spaceArray[i].getKernel());
        }
    }

}
