package ip.gabor;


import futils.Out;
import j2d.ImageUtils;
import graphics.NumImage;
import ip.gui.frames.ClosableFrame;
import ip.transforms.ConvolutionUtils;
import ip.transforms.Kernels;

import java.awt.*;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class FilterCanvas extends Canvas {
    private Image image;
    private short g[][];


    public FilterCanvas(Image img) {
        image = img;
        this.setSize(image.getWidth(this), image.getHeight(this));
        g = j2d.ImageUtils.getGreenFromImage(image, this);
    }

    public FilterCanvas() {
        image = NumImage.getImage();
        setSize(image.getWidth(this), image.getHeight(this));
        g = j2d.ImageUtils.getGreenFromImage(image, this);
    }

    public int getGreenValueAt(Point p) {
        int x = p.x;
        int y = p.y;
        if (x >= g.length) x = g.length - 1;
        if (y >= g[0].length) y = g[0].length - 1;
        if (x < 0) x = 0;
        if (y < 0) y = 0;
        return g[x][y];
    }

    public void drawImage() {
        this.repaint();
    }

    public Image getImage() {
        return image;
    }

    public void setImage(Image img) {
        image = img;
        setSize(image.getWidth(this), image.getHeight(this));
        g = j2d.ImageUtils.getGreenFromImage(image, this);
    }

    public void paint(Graphics graphics) {
        if (image != null)
            graphics.drawImage(image, 0, 0, getWidth(), getHeight(), this);

    }

    public void convolutionFast(Image img, float k[][]) {
        image = ImageUtils.convolution(image, k);
        setSize(image.getWidth(this), image.getHeight(this));
        repaint();
    }

    public void convolution(Image img, float k[][]) {
        short orig[][] = j2d.ImageUtils.getGreenFromImage(img, this);

        // The old slow way....
        orig = ConvolutionUtils.convolve(orig, k);
        //
        image = j2d.ImageUtils.getImage(orig);
        setSize(image.getWidth(this), image.getHeight(this));
        repaint();
    }


    public void saveAsJava(File f) {
        try {
            FileWriter fw =
                    new FileWriter(f);
            PrintWriter pw =
                    new PrintWriter(fw);
            Out.saveAsJava(pw, image, this);
            pw.flush();
            fw.close();
        } catch (Exception e) {
        }
    }

    public static FilterCanvas[] getFilterCanvas(Image img, ImageObserver io) {
        FilterCanvas fc[] = {
            new FilterCanvas(img),
            new FilterCanvas(
                    ConvolutionUtils.convolution(img,
                            Kernels.getRobinson1(), io)),
            new FilterCanvas(
                    ConvolutionUtils.convolution(img,
                            Kernels.getRobinson2(), io)),
            new FilterCanvas(
                    ConvolutionUtils.convolution(img,
                            Kernels.getRobinson3(), io)),
            new FilterCanvas(
                    ConvolutionUtils.convolution(img,
                            Kernels.getRobinson4(), io)),
            new FilterCanvas(
                    ConvolutionUtils.convolution(img,
                            Kernels.getRobinson5(), io)),
            new FilterCanvas(
                    ConvolutionUtils.convolution(img,
                            Kernels.getRobinson6(), io)),
            new FilterCanvas(
                    ConvolutionUtils.convolution(img,
                            Kernels.getRobinson7(), io)),
            new FilterCanvas(
                    ConvolutionUtils.convolution(img,
                            Kernels.getRobinson8(), io))
        };
        return fc;
    }

    public static FilterCanvas[] getSubBands(Image img, ImageObserver io) {
        ClosableFrame f = new ClosableFrame();
        f.setLayout(new GridLayout(4, 4));
        FilterCanvas[] fc = getFilterCanvas(img, io);
        for (int i = 0; i < fc.length; i++)
            f.add(fc[i]);
        f.show();
        return fc;
    }


}
