package ip.gabor;


import graphics.NumImage;

import java.awt.*;
import java.awt.image.BufferedImage;

class BufferedImageCanvas extends Canvas {
    private BufferedImage image;

    public BufferedImageCanvas(BufferedImage img) {
        image = img;
        this.setSize(image.getWidth(this), image.getHeight(this));
    }

    public BufferedImageCanvas() {
        Image img = NumImage.getImage();
        int w = img.getWidth(this);
        int h = img.getHeight(this);
        image = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
        setSize(image.getWidth(this), image.getHeight(this));
        Graphics2D g2 = image.createGraphics();
        g2.drawImage(img, 0, 0, this);
    }

    public void drawImage() {
        this.repaint();
    }

    public Image getImage() {
        return image;
    }

    public void setImage(BufferedImage img) {
        image = img;
    }

    public void paint(Graphics graphics) {
        if (image != null)
            graphics.drawImage(image, 0, 0, this);

    }


}
