package ip.apurva;

import futils.Futil;
import futils.WriterUtil;
import ip.gui.ImageSequence;
import ip.gui.frames.TopFrame;
import ip.transforms.Lifting;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class MyZipFile extends TopFrame implements ActionListener {
    ImageSequence imgsq = new ImageSequence();
    int count = 1;
    Vector imgvecr = new Vector();
    Vector imgvecg = new Vector();
    Vector imgvecb = new Vector();

    MenuBar mb = getMenuBar();
    Menu Zipmenu = new Menu("Wave Zip");
    MenuItem next_mi = addMenuItem(Zipmenu, "Next Entry");
    MenuItem ForLift_mi = addMenuItem(Zipmenu, "Forward Lifting");
    MenuItem BackLift_mi = addMenuItem(Zipmenu, "BackWard Lifting");
    MenuItem DHT_mi = addMenuItem(Zipmenu, "Split Radix for DHT");


    Menu s_plus_p_menu = new Menu("S + P Xforms");
    MenuItem S_plus_P_forward = addMenuItem(s_plus_p_menu, "S + P Forward");
    MenuItem clearband1 = addMenuItem(s_plus_p_menu, "Clear 1/2 band");
    MenuItem clearband2 = addMenuItem(s_plus_p_menu, "Clear 1/4 band");
    MenuItem clearband3 = addMenuItem(s_plus_p_menu, "Clear 1/8 band");
    MenuItem S_plus_P_inverse = addMenuItem(s_plus_p_menu, "S + P Inverse");

    public void actionPerformed(ActionEvent e) {
        if (match(e, DHT_mi)) {
            dHT_mi();
        }
        if (match(e, S_plus_P_forward)) {
            forward();
        }
        if (match(e, clearband1)) {
            clear_band1();
        }
        if (match(e, clearband2)) {
            clear_band2();
        }
        if (match(e, clearband3)) {
            clear_band3();
        }
        if (match(e, S_plus_P_inverse)) {
            inverse();
        }
        if (match(e, next_mi)) {
            nextentry();
            return;
        }
        if (match(e, ForLift_mi)) {
            forwardzip();
            return;
        }
        if (match(e, BackLift_mi)) {
            backwardzip();
            return;
        }
        super.actionPerformed(e);
    }


    public void dHT_mi() {
        /*DHT_SR dht_mi = new DHT_SR();
        dht_mi.initframe(r,g,b);
        short2Image();*/
    }

    public void forward() {
        Lifting.forwardHaar(shortImageBean.getR());
        Lifting.forwardHaar(shortImageBean.getG());
        Lifting.forwardHaar(shortImageBean.getB());
        SPxform.S_plus_P_Xform(shortImageBean.getR());
        SPxform.S_plus_P_Xform(shortImageBean.getG());
        SPxform.S_plus_P_Xform(shortImageBean.getB());
        short2Image();
    }

    public void clear_band1() {
        clear_band(0, getImageHeight() / 2, getImageWidth(), getImageHeight());
        short2Image();
    }

    public void clear_band2() {
        clear_band(0, getImageHeight() / 4, getImageWidth(), getImageHeight());
        short2Image();
    }

    public void clear_band3() {
        clear_band(0, getImageHeight() / 8, getImageWidth(), getImageHeight());
        short2Image();

    }

    public void clear_band(int x, int y, int x1, int y1) {
        for (int i = x; i < x1; i++) {
            for (int j = y; j < y1; j++) {
                shortImageBean.getR()[i][j] = 0;
                shortImageBean.getG()[i][j] = 0;
                shortImageBean.getB()[i][j] = 0;
            }
        }
    }

    public void inverse() {
        SPxform.inversXform(shortImageBean.getR());
        SPxform.inversXform(shortImageBean.getG());
        SPxform.inversXform(shortImageBean.getB());
        Lifting.backwardHaar(shortImageBean.getR());
        Lifting.backwardHaar(shortImageBean.getG());
        Lifting.backwardHaar(shortImageBean.getB());
        short2Image();
    }

    public void nextentry() {
        System.out.println("" + count);
        short[][] r = (short[][]) imgvecr.elementAt(count);
        shortImageBean.setR(r);
        setG((short[][]) imgvecg.elementAt(count));
        setB((short[][]) imgvecb.elementAt(count));
        Lifting.backwardHaar(shortImageBean.getR());
        Lifting.backwardHaar(shortImageBean.getB());
        Lifting.backwardHaar(shortImageBean.getG());
        short2Image();
        setImageWidth(shortImageBean.getR().length);
        setImageHeight(shortImageBean.getR()[0].length);
        setSize(getImageWidth(), getImageHeight());
        count--;
        if (count == -1)
            count = imgvecr.size() - 1;
    }

    public void forwardzip() {
        String filename = WriterUtil.getSaveFileName("Save as Zip file");
        try {
            //writing to a zip file
            FileOutputStream fos = new FileOutputStream(filename);
            ZipOutputStream zos = new ZipOutputStream(fos);
            Lifting.forwardHaar(shortImageBean.getR());
            Lifting.forwardHaar(shortImageBean.getG());
            Lifting.forwardHaar(shortImageBean.getB());
            int j,i;
            for (
                    i = getImageHeight(), j = 0;
                    i > getImageHeight() / 64; i = i / 2, j++) {
                ZipEntry zer = new ZipEntry("r" + i + "");
                ZipEntry zeg = new ZipEntry("g" + i + "");
                ZipEntry zeb = new ZipEntry("b" + i + "");
                zer.setMethod(ZipEntry.DEFLATED);
                zeg.setMethod(ZipEntry.DEFLATED);
                zeb.setMethod(ZipEntry.DEFLATED);
                zos.putNextEntry(zer);
                ObjectOutputStream oos = new ObjectOutputStream(zos);
                //clearing the sub bands by the multiples of 2
                clearQuad(0, i, getImageWidth(), getImageHeight());
                //writing serialized object to the gzip file
                oos.writeObject(shortImageBean.getR());
                zos.putNextEntry(zeg);
                oos.writeObject(shortImageBean.getG());
                zos.putNextEntry(zeb);
                oos.writeObject(shortImageBean.getB());
            }
            zos.finish();
            //applying backward lifting xform to show the last image od the sequence
            Lifting.backwardHaar(shortImageBean.getR());
            Lifting.backwardHaar(shortImageBean.getB());
            Lifting.backwardHaar(shortImageBean.getG());
            short2Image();
        } catch (Exception e) {
            System.out.println("Save as Zip file :" + e);
        }
    }


    public void backwardzip() {
        String filename = Futil.getReadFileName();


        try {
            FileInputStream fos = new FileInputStream(filename);
            ZipInputStream gos = new ZipInputStream(fos);
            ZipEntry ze;
            for (
                    int i = getImageHeight();
                    i > getImageHeight() / 64; i = i / 2) {
                ze = gos.getNextEntry();
                ze.setMethod(ZipEntry.DEFLATED);
                ObjectInputStream oos = new ObjectInputStream(gos);
                short[][] r = (short[][]) oos.readObject();
                shortImageBean.setR(r);
                imgvecr.addElement(shortImageBean.getR());
                ze = gos.getNextEntry();
                ze.setMethod(ZipEntry.DEFLATED);
                setB((short[][]) oos.readObject());
                imgvecg.addElement(shortImageBean.getG());
                ze = gos.getNextEntry();
                ze.setMethod(ZipEntry.DEFLATED);
                setG((short[][]) oos.readObject());
                imgvecb.addElement(shortImageBean.getB());
                setImageWidth(shortImageBean.getR().length);
                setImageHeight(shortImageBean.getR()[0].length);
                setSize(getImageWidth(), getImageHeight());
            }
            count = imgvecr.size() - 1;
            Lifting.backwardHaar(shortImageBean.getR());
            Lifting.backwardHaar(shortImageBean.getB());
            Lifting.backwardHaar(shortImageBean.getG());
            short2Image();
            gos.close();
        } catch (Exception e) {
            System.out.println("Open as Zip file :" + e);
        }

    }

    public void clearQuad(int x1, int y1, int x2, int y2) {
        for (int x = x1; x < x2; x++)
            for (int y = y1; y < y2; y++) {
                shortImageBean.getR()[x][y] = 0;
                shortImageBean.getG()[x][y] = 0;
                shortImageBean.getB()[x][y] = 0;
            }
    }

    MyZipFile() {
        super("MyZipFile");
        mb.add(Zipmenu);
        mb.add(s_plus_p_menu);


    }

    public static void main(String args[]) {
        new MyZipFile();
    }

}