package gui.run;

import java.awt.Container;
import java.awt.FlowLayout;


public abstract class ThreadedRunButton extends
        javax.swing.JButton implements
        java.awt.event.ActionListener, Runnable {
    public ThreadedRunButton(String label) {
        this(label, null);
    }

    public ThreadedRunButton(String l, javax.swing.Icon i) {
        super(l, i);
        addActionListener(this);
    }

    public ThreadedRunButton(javax.swing.Icon i) {
        this(null, i);
    }

    public ThreadedRunButton() {
        this(null, null);
    }

    private Thread t = null;

    /**
     *    interrupt the thread that the button started.
     */
    public void interrupt() {
        t.interrupt();
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        t = new Thread(this);
        t.start();
    }


    public static void main(String args[]) {
        final ThreadedRunButton sleepingButton = new ThreadedRunButton("sleep") {
            public void run() {
                try {
                    Thread.sleep(2000);
                    System.out.println("alarm!");
                } catch (InterruptedException ie) {
                    System.out.println("You woke me up!");
                }
            }
        };

        gui.ClosableJFrame cf =
                new gui.ClosableJFrame("Wake up!");
        Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());
        c.add(new ThreadedRunButton("wake the sleeper") {
            public void run() {
                sleepingButton.interrupt();
            }
        });
        c.add(sleepingButton);
        cf.setSize(200, 200);
        cf.show();
    }

}